#ifndef __MOS_DRIVERCOM_H_
#define __MOS_DRIVERCOM_H_

/*
 * Summary: drivercom.h
 * header file for the driver communication port
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

void drv_sendmessage(unsigned int dest, unsigned int size, char * buffer);
void drv_sendmessageany(unsigned int dest, unsigned int src, unsigned int size, char * buffer);
void drv_setname(int service, int index);
int drv_peekmessage(void);
int drv_peekmessageany(int * target);
int drv_readmessage(char * dest);
int drv_readmessageany(char * dest);
int drv_peeksender(void);

/* Structure: COMMPORT
 * Contains the read and write pointers for a shared message pipe
 */
typedef struct COMMPORT
{
    char * writept;
    char * readpt;
} COMMPORT;

/* Variable: _MOS_bootinfo
 * the message pipe the application received on startup.
 */
extern COMMPORT * _MOS_bootinfo;

#endif
