;
; Summary: inc_efi.asm
; *Equates for amd64 EFI*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

; EFI_HEADER
EFITABLE_SIGNATURE_OFF 			EQU 0
EFITABLE_REVISION_OFF 			EQU 8
EFITABLE_HEADERSIZE_OFF 		EQU 12
EFITABLE_CRC_OFF 			EQU 16
EFITABLE_RESERVED_OFF 			EQU 20
EFITABLE_SIZE 				EQU 24

; EFI_SYSTEM_TABLE
EFISYSTEMTABLE_SIGNATURE		EQU 0x5453595320494249
EFISYSTEMTABLE_HEADER_OFF		EQU 0
EFISYSTEMTABLE_FIRMWAREVENDOR_OFF	EQU EFITABLE_SIZE + 0x00
EFISYSTEMTABLE_FIRMWAREREVISION_OFF     EQU EFITABLE_SIZE + 0x08
EFISYSTEMTABLE_CONSOLEINHANDLE_OFF      EQU EFITABLE_SIZE + 0x10
EFISYSTEMTABLE_CONSOLEINPROTO_OFF       EQU EFITABLE_SIZE + 0x18
EFISYSTEMTABLE_CONSOLEOUTHANDLE_OFF     EQU EFITABLE_SIZE + 0x20
EFISYSTEMTABLE_CONSOLEOUTPROTO_OFF      EQU EFITABLE_SIZE + 0x28
EFISYSTEMTABLE_STANDARDERRORHANDLE_OFF  EQU EFITABLE_SIZE + 0x30
EFISYSTEMTABLE_STANDARDERRORPROTO_OFF   EQU EFITABLE_SIZE + 0x38
EFISYSTEMTABLE_RUNTIMESERVICES_OFF	EQU EFITABLE_SIZE + 0x40
EFISYSTEMTABLE_BOOTSERVICES_OFF	        EQU EFITABLE_SIZE + 0x48
EFISYSTEMTABLE_TABLEENTRIES_OFF	        EQU EFITABLE_SIZE + 0x50
EFISYSTEMTABLE_CONFIGURATIONTABLE_OFF	EQU EFITABLE_SIZE + 0x58

EFISYSTEMTABLE_SIZE			EQU 0x60 + EFITABLE_SIZE

; Statuses
EFI_SUCCESS		EQU 0
; Errors (result starts with 0b10)
EFI_LOAD_ERROR		EQU 1
EFI_INVALID_PARAMETER	EQU 2
EFI_UNSUPPORTED		EQU 3
EFI_BAD_BUFFER_SIZE	EQU 4
EFI_BUFFER_TOO_SMALL	EQU 5
EFI_NOT_READY		EQU 6

; EFI_BOOT_SERVICES
EFIBOOTSERVICES_SIGNATURE		EQU 0x56524553544f4f42
EFIBOOTSERVICES_HEADER_OFF		EQU 0
; EFI 1.0
EFIBOOTSERVICES_RAISE_TPL_OFF		EQU EFITABLE_SIZE + 0x000
EFIBOOTSERVICES_RESTORE_TPL_OFF		EQU EFITABLE_SIZE + 0x008
EFIBOOTSERVICES_ALLOCATE_PAGES_OFF 	EQU EFITABLE_SIZE + 0x010
EFIBOOTSERVICES_FREE_PAGES_OFF        	EQU EFITABLE_SIZE + 0x018
EFIBOOTSERVICES_GET_MEMORY_MAP_OFF	EQU EFITABLE_SIZE + 0x020
EFIBOOTSERVICES_ALLOCATE_POOL_OFF	EQU EFITABLE_SIZE + 0x028
EFIBOOTSERVICES_FREE_POOL_OFF		EQU EFITABLE_SIZE + 0x030
EFIBOOTSERVICES_CREATE_EVENT_OFF 	EQU EFITABLE_SIZE + 0x038
EFIBOOTSERVICES_SET_TIMER_OFF		EQU EFITABLE_SIZE + 0x040
EFIBOOTSERVICES_WAIT_FOR_EVENT_OFF	EQU EFITABLE_SIZE + 0x048
EFIBOOTSERVICES_SIGNAL_EVENT_OFF 	EQU EFITABLE_SIZE + 0x050
EFIBOOTSERVICES_CLOSE_EVENT_OFF		EQU EFITABLE_SIZE + 0x058
EFIBOOTSERVICES_CHECK_EVENT_OFF		EQU EFITABLE_SIZE + 0x060
EFIBOOTSERVICES_INSTALL_PROTOCOL_OFF	EQU EFITABLE_SIZE + 0x068
EFIBOOTSERVICES_REINSTALL_PROTOCOL_OFF	EQU EFITABLE_SIZE + 0x070
EFIBOOTSERVICES_UNINSTALL_PROTOCOL_OFF	EQU EFITABLE_SIZE + 0x078
;Official documentation error: There are two HANDLE_PROTOCOL-alikes here. 
;EFIBOOTSERVICES_HANDLE_PROTOCOL_OFF	EQU EFITABLE_SIZE + 0x080
EFIBOOTSERVICES_REGISTER_PROTOCOL_NOTIFY_OFF EQU EFITABLE_SIZE + 0x090
EFIBOOTSERVICES_LOCATE_HANDLE_OFF 	EQU EFITABLE_SIZE + 0x098
EFIBOOTSERVICES_LOCATE_DEVICE_PATH_OFF	EQU EFITABLE_SIZE + 0x0A0
EFIBOOTSERVICES_INSTALL_CONFIGURATION_TABLE_OFF EQU EFITABLE_SIZE + 0x0A8
EFIBOOTSERVICES_IMAGE_LOAD_OFF		EQU EFITABLE_SIZE + 0x0B0
EFIBOOTSERVICES_IMAGE_START_OFF 	EQU EFITABLE_SIZE + 0x0B8
EFIBOOTSERVICES_EXIT_OFF		EQU EFITABLE_SIZE + 0x0C0
EFIBOOTSERVICES_IMAGE_UNLOAD_OFF	EQU EFITABLE_SIZE + 0x0C8
EFIBOOTSERVICES_EXIT_BOOT_SERVICES_OFF 	EQU EFITABLE_SIZE + 0x0D0
EFIBOOTSERVICES_GET_NEXT_MONOTONIC_COUNT_OFF EQU EFITABLE_SIZE + 0x0D8
EFIBOOTSERVICES_STALL_OFF 		EQU EFITABLE_SIZE + 0x0E0
EFIBOOTSERVICES_SET_WATCHDOG_TIMER_OFF 	EQU EFITABLE_SIZE + 0x0E8
; EFI 1.1
EFIBOOTSERVICES_CONNECT_CONTROLLER_OFF 	EQU EFITABLE_SIZE + 0x0F0
EFIBOOTSERVICES_DISCONNECT_CONTROLLER_OFF EQU EFITABLE_SIZE + 0x0F8
EFIBOOTSERVICES_OPEN_PROTOCOL_OFF 	EQU EFITABLE_SIZE + 0x100
EFIBOOTSERVICES_CLOSE_PROTOCOL_OFF 	EQU EFITABLE_SIZE + 0x108
EFIBOOTSERVICES_OPEN_PROTOCOL_INFORMATION_OFF EQU EFITABLE_SIZE + 0x110

; LOCATE_HANDLE
EFI_LOCATE_ALLHANDLES 			EQU 0
EFI_LOCATE_BYREGISTERNOTIFY		EQU 1
EFI_LOCATE_BYPROTOCOL			EQU 2

; OPEN_PROTOCOL
EFI_OPEN_PROTOCOL_BY_HANDLE_PROTOCOL	EQU 0x01
EFI_OPEN_PROTOCOL_GET_PROTOCOL		EQU 0x02
EFI_OPEN_PROTOCOL_TEST_PROTOCOL		EQU 0x04
EFI_OPEN_PROTOCOL_BY_CHILD_CONTROLLER	EQU 0x08
EFI_OPEN_PROTOCOL_BY_DRIVER		EQU 0x10
EFI_OPEN_PROTOCOL_EXCLUSIVE		EQU 0x20

; EFI_SIMPLE_TEXT_OUTPUT_PROTOCOL
EFI_STOP_RESET_OFF			EQU 0x00
EFI_STOP_OUTPUTSTRING_OFF		EQU 0x08
EFI_STOP_TESTSTRING_OFF			EQU 0x10
EFI_STOP_QUERYMODE_OFF			EQU 0x18
EFI_STOP_SETMODE_OFF			EQU 0x20
EFI_STOP_SETATTRIBUTE_OFF		EQU 0x28
EFI_STOP_CLEARSCREEN_OFF		EQU 0x30
EFI_STOP_SETCURSORPOSITION_OFF		EQU 0x38
EFI_STOP_ENABLECURSOR_OFF		EQU 0x40
EFI_STOP_MODE_OFF			EQU 0x48

; EFI_SIMPLE_TEXT_INPUT_PROTOCOL
EFI_STIP_RESET_OFF			EQU 0x00
EFI_STIP_READ_KEY_OFF			EQU 0x08
EFI_STIP_EVENT_OFF			EQU 0x10

; EFI_GRAPHICS_OUTPUT_PROTOCOL
EFI_GOP_QUERY_MODE_OFF			EQU 0x00
EFI_GOP_SET_MODE_OFF			EQU 0x08
EFI_GOP_BLT_OFF				EQU 0x10
EFI_GOP_MODE_OFF			EQU 0x18

; struct EFI_PIXEL_BITMASK
EFI_PIXEL_BITMASK_R_OFF			EQU 0x00
EFI_PIXEL_BITMASK_G_OFF			EQU 0x04
EFI_PIXEL_BITMASK_B_OFF			EQU 0x08
EFI_PIXEL_BITMASK_X_OFF			EQU 0x0C

; enum EFI_GRAPHICS_PIXEL_FORMAT
EFI_PIXEL_FORMAT_RGB8			EQU 0
EFI_PIXEL_FORMAT_BGR8			EQU 1
EFI_PIXEL_FORMAT_MASK			EQU 2
EFI_PIXEL_FORMAT_BLT_ONLY		EQU 3
EFI_PIXEL_FORMAT_MAX			EQU 4

;EFI_GRAPHICS_OUTPUT_MODE_INFORMATION
EFI_GOP_MODEINFO_VERSION_OFF		EQU 0x00
EFI_GOP_MODEINFO_H_RESOLUTION_OFF	EQU 0x04
EFI_GOP_MODEINFO_V_RESOLUTION_OFF	EQU 0x08
EFI_GOP_MODEINFO_PIXEL_FORMAT_OFF	EQU 0x0C
EFI_GOP_MODEINFO_BITMASK_OFF		EQU 0x10
EFI_GOP_MODEINFO_PIXELS_PER_SCANLINE_OFF EQU 0x20

;EFI_GRAPHICS_OUTPUT_PROTOCOL_MODE
EFI_GOP_MODE_MAXMODE_OFF		EQU 0x00
EFI_GOP_MODE_MODE_OFF			EQU 0x04
EFI_GOP_MODE_INFO_OFF			EQU 0x08
EFI_GOP_MODE_SIZEOF_INFO_OFF		EQU 0x10
EFI_GOP_MODE_FRAMEBUFFERBASE_OFF	EQU 0x18
EFI_GOP_MODE_FRAMEBUFFERSIZE_OFF	EQU 0x20

