;
; Summary: inc_chips.asm
; *Equates for standard AT hardware*
;
; contains definitions of:
; - PIC (programmable interrupt controller)
; - PIT (programmable interval timer)
;
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

; ----------------------------------------
; Group: Programmable Interrupt Controller
; ----------------------------------------

PIC1_BASE           EQU 0x20
PIC2_BASE           EQU 0xA0
PIC1_COMMAND        EQU PIC1_BASE
PIC1_DATA           EQU (PIC1_BASE+1)
PIC2_COMMAND        EQU PIC2_BASE
PIC2_DATA           EQU (PIC2_BASE+1)
PIC_EOI             EQU 0x20

PIC_ICW1_ICW4       EQU 0x01            ; ICW4 (not) needed */
PIC_ICW1_SINGLE     EQU 0x02            ; Single (cascade) mode */
PIC_ICW1_INTERVAL4  EQU 0x04            ; Call address interval 4 (8) */
PIC_ICW1_LEVEL      EQU 0x08            ; Level triggered (edge) mode */
PIC_ICW1_INIT       EQU 0x10            ; Initialization - required! */

PIC_ICW2_VMASK      EQU 0xf8            ; Interrupt vector mask

PIC_ICW4_8086       EQU 0x01            ; 8086/88 (MCS-80/85) mode */
PIC_ICW4_AUTO       EQU 0x02            ; Auto (normal) EOI */
PIC_ICW4_BUF_SLAVE  EQU 0x08            ; Buffered mode/slave */
PIC_ICW4_BUF_MASTER EQU 0x0C            ; Buffered mode/master */
PIC_ICW4_SFNM       EQU 0x10            ; Special fully nested (not) */

; ----------------------------------------
; Group: Programmable Interval Timer
; ----------------------------------------

PIT_BASE            EQU 0x40
PIT_CHAN0           EQU PIT_BASE + 0    ; channel 0 data register
PIT_CHAN1           EQU PIT_BASE + 1    ; channel 1 data register
PIT_CHAN2           EQU PIT_BASE + 2    ; channel 2 data register
PIT_COMMAND         EQU PIT_BASE + 3    ; mode/command register

PIT_CW_BCD          EQU 0x01
PIT_CW_BINARY       EQU 0x00
PIT_CW_MODE0        EQU 0x00
PIT_CW_MODE1        EQU 0x02
PIT_CW_MODE2        EQU 0x04
PIT_CW_MODE3        EQU 0x06
PIT_CW_MODE4        EQU 0x08
PIT_CW_MODE5        EQU 0x0A
PIT_CW_TERMCOUNT    EQU PIT_CW_MODE0    ; Mode 0: Interrupt on terminal count
PIT_CW_PROGONESHOT  EQU PIT_CW_MODE1    ; Mode 1: Programmable One-Shot
PIT_CW_RATE         EQU PIT_CW_MODE2    ; Mode 2: Rate Generator
PIT_CW_SQUAREWAVE   EQU PIT_CW_MODE3    ; Mode 3: Square Wave Rate Generator
PIT_CW_SWSTROBE     EQU PIT_CW_MODE4    ; Mode 4: Software Triggered Strobe
PIT_CW_HWSTROBE     EQU PIT_CW_MODE5    ; Mode 5: Hardware Triggered Strobe
PIT_CW_LATCH        EQU 0
PIT_CW_LO           EQU 0x10
PIT_CW_HI           EQU 0x20
PIT_CW_LOHI         EQU 0x30
PIT_CW_CHAN0        EQU 0x00
PIT_CW_CHAN1        EQU 0x40
PIT_CW_CHAN2        EQU 0x80