;
; Summary: inc_elf.asm
; *Equates for th ELF file format*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

EI_MAG0     EQU 0
EI_MAG1     EQU 1
EI_MAG2     EQU 2
EI_MAG3     EQU 3
EI_CLASS    EQU 4
EI_DATA     EQU 5
EI_VERSION  EQU 6
EI_PAD      EQU 7
EI_NIDENT   EQU 16

E_TYPE      EQU EI_NIDENT + 0
E_MACHINE   EQU EI_NIDENT + 2
E_VERSION   EQU EI_NIDENT + 4
E_ENTRY     EQU EI_NIDENT + 8
E_PHOFF     EQU EI_NIDENT + 12
E_SHOFF     EQU EI_NIDENT + 16
E_FLAGS     EQU EI_NIDENT + 20
E_EHSIZE    EQU EI_NIDENT + 24
E_PHENTSIZE EQU EI_NIDENT + 26
E_PHNUM     EQU EI_NIDENT + 28
E_SHENTSIZE EQU EI_NIDENT + 30
E_SHNUM     EQU EI_NIDENT + 32
E_SHSTRNDX  EQU EI_NIDENT + 34
ELFHDR_SIZE EQU EI_NIDENT + 36

P_TYPE      EQU 0
P_OFFSET    EQU 4
P_VADDR     EQU 8
P_PADDR     EQU 12
P_FILESZ    EQU 16
P_MEMSZ     EQU 20
P_ALIGN     EQU 24

ET_NONE     EQU 0x0000
ET_REL      EQU 0x0001
ET_EXEC     EQU 0x0002
ET_DYN      EQU 0x0003
ET_CORE     EQU 0x0004
ET_LOPROC   EQU 0xff00
ET_HIPROC   EQU 0xffff

EM_NONE     EQU 0x0
EM_M32      EQU 0x1
EM_SPARC    EQU 0x2
EM_386      EQU 0x3
EM_68K      EQU 0x4
EM_88K      EQU 0x5
EM_860      EQU 0x7
EM_MIPS     EQU 0x8
EM_X86_64   EQU 0x3E

EV_NONE     EQU 0
EV_CURRENT  EQU 1

ELFCLASSNONE EQU 0
ELFCLASS32  EQU 1
ELFCLASS64  EQU 2

ELFDATANONE EQU 0
ELFDATA2LSB EQU 1
ELFDATA2MSB EQU 2

SH_NAME     EQU 0
SH_TYPE     EQU 4
SH_FLAGS    EQU 8
SH_ADDR     EQU 12
SH_OFFSET   EQU 16
SH_SIZE     EQU 20
SH_LINK     EQU 24
SH_INFO     EQU 28
SH_ADDRALIGN EQU 32
SH_ENTSIZE  EQU 36
ELFSHDR_SIZE EQU 40

SHN_UNDEF   EQU 0
SHN_LORESERVE EQU 0xff00
SHN_LOPROC  EQU 0xff00
SHN_HIPROC  EQU 0xff1f
SHN_ABS     EQU 0xfff1
SHN_COMMON  EQU 0xfff2
SHN_HIRESERVE EQU 0xffff

SHT_NULL    EQU 0
SHT_PROGBITS EQU 1
SHT_SYMTAB  EQU 2
SHT_STRTAB  EQU 3
SHT_RELA    EQU 4
SHT_HASH    EQU 5
SHT_DYNAMIC EQU 6
SHT_NOTE    EQU 7
SHT_NOBITS  EQU 8
SHT_REL     EQU 9
SHT_SHLIB   EQU 10
SHT_DYNSYM  EQU 11
SHT_LOPROC  EQU 0x70000000
SHT_HIPROC  EQU 0x7fffffff
SHT_LOUSER  EQU 0x80000000
SHT_HIUSER  EQU 0xffffffff

ST_NAME     EQU 0
ST_VALUE    EQU 4
ST_SIZE     EQU 8
ST_INFO     EQU 12
ST_OTHER    EQU 13
ST_SHNDX    EQU 14

PT_NULL     EQU 0
PT_LOAD     EQU 1
PT_DYNAMIC  EQU 2
PT_INTERP   EQU 3
PT_NOTE     EQU 4
PT_SHLIB    EQU 5
PT_PHDR     EQU 6
PT_LOPROC   EQU 0x70000000
PT_HIPROC   EQU 0x7fffffff