;
; Summary: inc_ia.asm
; *Equates for processor constants*
;
; Probably THE file to rip for starting osdevers :p
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

PAGE_SYS_UNDEF      EQU 0x000
PAGE_SYS_MEMORY     EQU 0x200
PAGE_SYS_NONEALLOC  EQU 0x00000000
PAGE_SYS_ONEALLOC   EQU 0x00010000
PAGE_SYS_ALLOCMASK  EQU 0xffff0000
PAGE_SYS_DATAMASK   EQU 0x0000ffff
PAGE_SYS_FREEMASK   EQU 0x000007ff

PAGE_PRESENT        EQU 0x001
PAGE_WRITABLE       EQU 0x002
PAGE_USERSPACE      EQU 0x004
PAGE_WRITETHROUGH   EQU 0x008
PAGE_UNCACHEABLE    EQU 0x010
PAGE_ACCESSED       EQU 0x020
PAGE_DIRTY          EQU 0x040
PAGE_GRANULAR       EQU 0x080
PAGE_GLOBAL         EQU 0x100
PAGE_FREE           EQU 0xE00
PAGE_FREE1          EQU 0x200
PAGE_FREE2          EQU 0x400
PAGE_FREE3          EQU 0x800
PAGE_NOEXECUTE      EQU 0x8000000000000000

PAGE_PRESENT_BIT    EQU 0
PAGE_WRITABLE_BIT   EQU 1
PAGE_USERSPACE_BIT  EQU 2
PAGE_WT_BIT         EQU 3
PAGE_UC_BIT         EQU 4
PAGE_ACCESSED_BIT   EQU 5
PAGE_DIRTY_BIT      EQU 6
PAGE_GRANULAR_BIT   EQU 7
PAGE_GLOBAL_BIT     EQU 8
PAGE_FREE1_BIT      EQU 9
PAGE_FREE2_BIT      EQU 10
PAGE_FREE3_BIT      EQU 11
PAGE_NOEXECUTE_BIT  EQU 63

PAGE_SIZE           EQU 4096
PAGE_SIZE_BITS      EQU 12

PAGE_ALLOCMASK      EQU 0x00000e00
PAGE_FREEMASK       EQU 0xfffffffe
PAGE_FLAGMASK       EQU 0x000001ff
PAGE_ADDRMASK       EQU 0xfffff000
PAGE_DIRECTORYMASK  EQU 0xffc00000
PAGE_TABLEMASK      EQU 0x003ff000
PAGE_PARAMMASK      EQU 0x00000fff
PAGE_PAE_MASK1      EQU 0x001ff000
PAGE_PAE_MASK2      EQU 0x3fe00000
PAGE_PAE_MASK3      EQU 0xc0000000
PAGE_PAE_MASK3_L    EQU 0x0000007fc0000000
PAGE_PAE_MASK4_L    EQU 0x0000ff8000000000

GDT_LIMIT_LO        EQU 0
GDT_LIMIT_HI        EQU 6
GDT_LIMIT_HIMASK    EQU 0xf
GDT_BASE_LO         EQU 2
GDT_BASE_HA         EQU 4
GDT_BASE_HI         EQU 7
GDT_FLAGS_LO        EQU 5
GDT_FLAGS_HI        EQU 6
GDT_FLAG_PAGES      EQU 0x80
GDT_FLAG_16BIT      EQU 0x00
GDT_FLAG_32BIT      EQU 0x40
GDT_FLAG_SYS        EQU 0x10
GDT_FLAG_PRESENT    EQU 0x80
GDT_FLAG_DPLMASK    EQU (0x40 | 0x20)
GDT_FLAG_RING0      EQU 0x00
GDT_FLAG_RING1      EQU 0x20
GDT_FLAG_RING2      EQU 0x40
GDT_FLAG_RING3      EQU 0x60

GDT_TYPE_ACCESSED   EQU 0x01
GDT_TYPE_CODE       EQU 0x18
GDT_TYPE_CONFORMING EQU 0x04
GDT_TYPE_CONSTANTS  EQU 0x02
GDT_TYPE_DATA       EQU 0x10
GDT_TYPE_DIRECTION  EQU 0x04
GDT_TYPE_DATARW     EQU 0x02

GDT_TYPE_TSS16      EQU 0x01
GDT_TYPE_LDT        EQU 0x02
GDT_TYPE_TSS16BUSY  EQU 0x03
GDT_TYPE_TSS32      EQU 0x09
GDT_TYPE_TSS32BUSY  EQU 0x0b
GDT_TYPE_BUSYFLAG   EQU 0x02

IDT_TYPE_TASK       EQU 0x05
IDT_TYPE_CALL16     EQU 0x04
IDT_TYPE_INT16      EQU 0x06
IDT_TYPE_TRAP16     EQU 0x07
IDT_TYPE_CALL32     EQU 0x0c
IDT_TYPE_INT32      EQU 0x0e
IDT_TYPE_TRAP32     EQU 0x0f

IDT_FLAG_DPL0       EQU 0x00
IDT_FLAG_DPL1       EQU 0x20
IDT_FLAG_DPL2       EQU 0x40
IDT_FLAG_DPL3       EQU 0x60

IDT_FLAG_PRESENT    EQU 0x80

IDT_SELECTOR_OFFS   EQU 2
IDT_OFFSET_LO       EQU 0
IDT_OFFSET_HI       EQU 6
IDT_FLAG_OFFS       EQU 5

CR0_PE              EQU 0x00000001
CR0_MP              EQU 0x00000002
CR0_EM              EQU 0x00000004
CR0_TS              EQU 0x00000008
CR0_ET              EQU 0x00000010
CR0_NE              EQU 0x00000020
CR0_WP              EQU 0x00010000
CR0_AM              EQU 0x00040000
CR0_CD              EQU 0x40000000
CR0_PG              EQU 0x80000000

CR4_VME             EQU 0x00000001
CR4_PVI             EQU 0x00000002
CR4_TSD             EQU 0x00000004
CR4_DE              EQU 0x00000008
CR4_PSE             EQU 0x00000010
CR4_PAE             EQU 0x00000020
CR4_MCE             EQU 0x00000040
CR4_PGE             EQU 0x00000080
CR4_PCE             EQU 0x00000100
CR4_OSFXSR          EQU 0x00000200
CR4_OSXMMEXCPT      EQU 0x00000400

TSS_BACKLINK        EQU 0
TSS_ESP0            EQU 4
TSS_SS0             EQU 8
TSS_ESP1            EQU 12
TSS_SS1             EQU 16
TSS_ESP2            EQU 20
TSS_SS2             EQU 24
TSS_CR3             EQU 28
TSS_EIP             EQU 32
TSS_EFLAGS          EQU 36
TSS_EAX             EQU 40
TSS_ECX             EQU 44
TSS_EDX             EQU 48
TSS_EBX             EQU 52
TSS_ESP             EQU 56
TSS_EBP             EQU 60
TSS_ESI             EQU 64
TSS_EDI             EQU 68
TSS_ES              EQU 72
TSS_CS              EQU 76
TSS_SS              EQU 80
TSS_DS              EQU 84
TSS_FS              EQU 88
TSS_GS              EQU 92
TSS_LDT             EQU 96
TSS_TRAP            EQU 100
TSS_IOBASE          EQU 102

EFLAGS_CF           EQU 0x0001
EFLAGS_PF           EQU 0x0004
EFLAGS_AF           EQU 0x0010
EFLAGS_ZF           EQU 0x0040
EFLAGS_SF           EQU 0x0080
EFLAGS_TF           EQU 0x0100
EFLAGS_IF           EQU 0x0200
EFLAGS_DF           EQU 0x0400
EFLAGS_OF           EQU 0x0800
EFLAGS_NT           EQU 0x4000
EFLAGS_IOPL0        EQU 0x0000
EFLAGS_IOPL1        EQU 0x1000
EFLAGS_IOPL2        EQU 0x2000
EFLAGS_IOPL3        EQU 0x3000
EFLAGS_IOPLMASK     EQU 0x3000
EFLAGS_RF           EQU 0x00010000
EFLAGS_VM           EQU 0x00020000
EFLAGS_AC           EQU 0x00040000
EFLAGS_VIF          EQU 0x00080000
EFLAGS_VIP          EQU 0x00100000
EFLAGS_ID           EQU 0x00200000

; Local APIC registers
LAPIC_BASE          EQU 0xFEE00000
LAPIC_REG_APIC_ID   EQU LAPIC_BASE + 0x020      ; APIC ID register
LAPIC_REG_VERSION   EQU LAPIC_BASE + 0x030      ; APIC version register
LAPIC_REG_SVR       EQU LAPIC_BASE + 0x0F0      ; Spurious Vector Regsiter
LAPIC_REG_ESR       EQU LAPIC_BASE + 0x280      ; Error Status Register
LAPIC_REG_ICR_LOW   EQU LAPIC_BASE + 0x300      ; Interrupt Command Register (Lo)
LAPIC_REG_ICR_HI    EQU LAPIC_BASE + 0x310      ; Interrupt Command Register (Hi)
LAPIC_REG_LVT0      EQU LAPIC_BASE + 0x320      ; Local vector table 0 (timer)
LAPIC_REG_LVT3      EQU LAPIC_BASE + 0x370      ; Local vector table 3 (error)
LAPIC_REG_ICOUNT    EQU LAPIC_BASE + 0x380      ; Timer Initial Count
LAPIC_REG_CCOUNT    EQU LAPIC_BASE + 0x390      ; Timer Current Count
LAPIC_REG_DCR       EQU LAPIC_BASE + 0x3E0      ; Timer Divide Control Register

; APIC: Version bits
LAPIC_VER_VERMASK   EQU 0x000000ff
LAPIC_VER_MAJOR     EQU 0x000000f0
LAPIC_VER_MINOR     EQU 0x0000000f
LAPIC_VER_486       EQU 0x00000000
LAPIC_VER_PENTIUM   EQU 0x00000010
LAPIC_VER_LVTMAX    EQU 0x00ff0000
; APIC: SVR bits
LAPIC_ENABLED       EQU 0x00000100
; APIC: ICR bits
LAPIC_ICR_VECTORMASK    EQU 0x000000ff
LAPIC_ICR_INT_FIX       EQU 0x00000000
LAPIC_ICR_INT_LOW       EQU 0x00000100
LAPIC_ICR_INT_SMI       EQU 0x00000200
LAPIC_ICR_INT_NMI       EQU 0x00000400
LAPIC_ICR_INT_INIT      EQU 0x00000500
LAPIC_ICR_INT_SIPI      EQU 0x00000600
LAPIC_ICR_DEST_PHYS     EQU 0x00000000
LAPIC_ICR_DEST_LOG      EQU 0x00000800
LAPIC_ICR_DS_IDLE       EQU 0x00000000
LAPIC_ICR_DS_PENDING    EQU 0x00001000
LAPIC_ICR_LVL_ASSERT    EQU 0x00004000
LAPIC_ICR_LVL_DEASSERT  EQU 0x00000000
LAPIC_ICR_T_EDGE        EQU 0x00000000
LAPIC_ICR_T_LEVEL       EQU 0x00008000
LAPIC_ICR_SH_ADDR       EQU 0x00000000
LAPIC_ICR_SH_SELF       EQU 0x00040000
LAPIC_ICR_SH_ALL        EQU 0x00080000
LAPIC_ICR_SH_OTHERS     EQU 0x000C0000
LAPIC_ICR_RESERVED      EQU 0xfff32000

; CPUID - Query 1 EDX bits
CPUID_FPU           EQU 0x00000001
CPUID_VME           EQU 0x00000002
CPUID_DE            EQU 0x00000004
CPUID_PSE           EQU 0x00000008
CPUID_TSC           EQU 0x00000010
CPUID_MSR           EQU 0x00000020
CPUID_PAE           EQU 0x00000040
CPUID_MCE           EQU 0x00000080
CPUID_CMPXCHG8B     EQU 0x00000100
CPUID_APIC          EQU 0x00000200
CPUID_10            EQU 0x00000400
CPUID_SYSENTER      EQU 0x00000800
CPUID_MTRR          EQU 0x00001000
CPUID_PGE           EQU 0x00002000
CPUID_MCA           EQU 0x00004000
CPUID_CMOV          EQU 0x00008000
CPUID_PAT           EQU 0x00010000
CPUID_PSE36         EQU 0x00020000
CPUID_PSN           EQU 0x00040000
CPUID_CLFLUSH       EQU 0x00080000
CPUID_20            EQU 0x00100000
CPUID_DTES          EQU 0x00200000
CPUID_ACPI          EQU 0x00400000
CPUID_MMX           EQU 0x00800000
CPUID_FXSR          EQU 0x01000000
CPUID_SSE           EQU 0x02000000
CPUID_SSE2          EQU 0x04000000
CPUID_SS            EQU 0x08000000
CPUID_HTT           EQU 0x10000000
CPUID_TM1           EQU 0x20000000
CPUID_IA64          EQU 0x40000000
CPUID_PBE           EQU 0x80000000

; CPUID - Query 1 ECX bits
CPUID_SSE3          EQU 0x00000001
CPUID_CMPXCHG16B    EQU 0x00002000

; CPUID - Query 80000001 EDX bits
; bits 0-10, 12-17, 23-24 match the standard features
CPUID_SYSCALL       EQU 0x00000800
CPUID_NX            EQU 0x00100000
CPUID_MMXEXT        EQU 0x00400000
CPUID_FFXSR         EQU 0x02000000
CPUID_RDTSCP        EQU 0x08000000
CPUID_LM            EQU 0x20000000
CPUID_3DNOWEXT      EQU 0x40000000
CPUID_3DNOW         EQU 0x80000000

; CPUID - Query 80000001 ECX bits
CPUID_LAHFSAHF      EQU 0x00000001
CPUID_CMPLEAGCY     EQU 0x00000002
CPUID_SVM           EQU 0x00000004
CPUID_ALTCR         EQU 0x00000010

; CPUID - Kernel cpu info report
; the first set matches standard CPUID
; the second set is custom built due to the amount of overlapping
; bits in the three other cpu feature dwords
KCPUID_FPU          EQU CPUID_FPU
KCPUID_VME          EQU CPUID_VME
KCPUID_DE           EQU CPUID_DE
KCPUID_PSE          EQU CPUID_PSE
KCPUID_TSC          EQU CPUID_TSC
KCPUID_MSR          EQU CPUID_MSR
KCPUID_PAE          EQU CPUID_PAE
KCPUID_MCE          EQU CPUID_MCE
KCPUID_CMPXCHG8B    EQU CPUID_CMPXCHG8B
KCPUID_APIC         EQU CPUID_APIC
KCPUID_10           EQU 0x00000400
KCPUID_SYSENTER     EQU CPUID_SYSENTER
KCPUID_MTRR         EQU CPUID_MTRR
KCPUID_PGE          EQU CPUID_PGE
KCPUID_MCA          EQU CPUID_MCA
KCPUID_CMOV         EQU CPUID_CMOV
KCPUID_PAT          EQU CPUID_PAT
KCPUID_PSE36        EQU CPUID_PSE36
KCPUID_PSN          EQU CPUID_PSN
KCPUID_CLFLUSH      EQU CPUID_CLFLUSH
KCPUID_20           EQU 0x00100000
KCPUID_DTES         EQU CPUID_DTES
KCPUID_ACPI         EQU CPUID_ACPI
KCPUID_MMX          EQU CPUID_MMX
KCPUID_FXSR         EQU CPUID_FXSR
KCPUID_SSE          EQU CPUID_SSE
KCPUID_SSE2         EQU CPUID_SSE2
KCPUID_SS           EQU CPUID_SS
KCPUID_HTT          EQU CPUID_HTT
KCPUID_TM1          EQU CPUID_TM1
KCPUID_IA64         EQU CPUID_IA64
KCPUID_PBE          EQU CPUID_PBE

KCPUID_SSE3         EQU 0x00000001
KCPUID_SSE4         EQU 0x00000002
KCPUID_3DNOW        EQU 0x00000004
KCPUID_3DNOWEXT     EQU 0x00000008
KCPUID_486          EQU 0x00000010
KCPUID_MMXEXT       EQU 0x00000020
KCPUID_CYRIXMMX     EQU 0x00000040
KCPUID_AMD64        EQU 0x00000080

; kernel architecture
KARCH_UNKNOWN       EQU 0x00
KARCH_486           EQU 0x01
KARCH_PENTIUM       EQU 0x02
KARCH_AMD           EQU 0x03
KARCH_CYRIX         EQU 0x04


; MSRS - Model Specific Registers (Intel)
MSR_APICBASE        EQU 0x001B
MSR_APICBASE_ENABLE EQU 0x00000800
MSR_APICBASE_BSP    EQU 0x00000100
MSR_SYSENTER_CS     EQU 0x0174
MSR_SYSENTER_ESP    EQU 0x0175
MSR_SYSENTER_EIP    EQU 0x0176

; Cyrix MSRs
CYRIX_CCR0          EQU 0xC0
CYRIX_CCR1          EQU 0xC1
CYRIX_CCR2          EQU 0xC2
CYRIX_CCR3          EQU 0xC3
CYRIX_CCR4          EQU 0xE8
CYRIX_CCR5          EQU 0xE9
CYRIX_ARR0          EQU 0xC4
CYRIX_ARR1          EQU 0xC7
CYRIX_ARR2          EQU 0xCA
CYRIX_ARR3          EQU 0xCD
CYRIX_ARR4          EQU 0xD0
CYRIX_ARR5          EQU 0xD3
CYRIX_ARR6          EQU 0xD6
CYRIX_ARR7          EQU 0xD9
CYRIX_RCR0          EQU 0xDC
CYRIX_RCR1          EQU 0xDD
CYRIX_RCR2          EQU 0xDE
CYRIX_RCR3          EQU 0xDF
CYRIX_RCR4          EQU 0xE0
CYRIX_RCR5          EQU 0xE1
CYRIX_RCR6          EQU 0xE2
CYRIX_RCR7          EQU 0xE3
CYRIX_DIR0          EQU 0xFE
CYRIX_DIR1          EQU 0xFF

; SSE
MXCSR_IE            EQU 0x00000001
MXCSR_DE            EQU 0x00000002
MXCSR_ZE            EQU 0x00000004
MXCSR_OE            EQU 0x00000008
MXCSR_UE            EQU 0x00000010
MXCSR_PE            EQU 0x00000020
MXCSR_EXCPTBITS     EQU 0x0000003f
MXCSR_DAZ           EQU 0x00000040
MXCSR_IM            EQU 0x00000080
MXCSR_DM            EQU 0x00000100
MXCSR_ZM            EQU 0x00000200
MXCSR_OM            EQU 0x00000400
MXCSR_UM            EQU 0x00000800
MXCSR_PM            EQU 0x00001000
MXCSR_MASKBITS      EQU 0x00001f80
MXCSR_RC_NEAREST    EQU 0x00000000
MXCSR_RC_DOWNWARD   EQU 0x00002000
MXCSR_RC_UPWARD     EQU 0x00004000
MXCSR_RC_TRUNCATE   EQU 0x00006000
MXCSR_RCBITS        EQU 0x00006000
MXCSR_FZ            EQU 0x00008000
