/* Summary: x86.h
 * *Contains the definitions of various architecture-specific functions*
 *
 * Author: 
 *     Marcel Sondaar
 *
 * License:
 *     Public Domain
 *
 * Defines:
 *     <outportb> <outportw> <outportd>
 *     <inportb> <inportw> <inportd>
 *
 * Linker parameters:
 *     -lx86
 */

#ifndef _X86_H_
#define _X86_H_

void               outportb(int port, unsigned char value);
void               outportw(int port, unsigned short int value);
void               outportd(int port, unsigned int value);

unsigned char      inportb(int port);
unsigned short int inportw(int port);
unsigned int       inportd(int port);

#endif
