' Summary: gl.bi
' Defines 3D functions for FreeBasic
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
#ifndef _GL_GL_BI_
#define _GL_GL_BI_

Declare Sub glBegin         CDecl Alias "glBegin"       (ByVal mode As Integer)
Declare Sub glClear         CDecl Alias "glClear"       (ByVal mask As Integer)
Declare Sub glClearColor    CDecl Alias "glClearColor"  (ByVal red As Single, ByVal green As Single, ByVal blue As Single, ByVal alpha As Single)
Declare Sub glColor3f       CDecl Alias "glColor3f"     (ByVal red As Single, ByVal green As Single, ByVal blue As Single)
Declare Sub glColor4f       CDecl Alias "glColor4f"     (ByVal red As Single, ByVal green As Single, ByVal blue As Single, ByVal alpha As Single)
Declare Sub glCullFace      CDecl Alias "glCullFace"    (ByVal mode As Integer)
Declare Sub glDisable       CDecl Alias "glDisable"     (ByVal cap As Integer)
Declare Sub glEnable        CDecl Alias "glEnable"      (ByVal cap As Integer)
Declare Sub glEnd           CDecl Alias "glEnd"         ()
Declare Sub glFrustum       CDecl Alias "glFrustum"     (ByVal l As Double, ByVal r As Double, ByVal b As Double, ByVal t As double, ByVal near As Double, ByVal far As Double)
Declare Sub glLoadIdentity  CDecl Alias "glLoadIdentity"()
Declare Sub glMatrixMode    CDecl Alias "glMatrixMode"  (ByVal mode As Integer)
Declare Sub glRotatef       CDecl Alias "glRotatef"     (ByVal angle As Single, ByVal x As Single, ByVal y As Single, ByVal z As Single)
Declare Sub glRotated       CDecl Alias "glRotated"     (ByVal angle As Double, ByVal x As Double, ByVal y As Double, ByVal z As Double)
Declare Sub glScalef        CDecl Alias "glScalef"      (ByVal x As Single, ByVal y As Single, ByVal z As Single)
Declare Sub glScaled        CDecl Alias "glScaled"      (ByVal x As Double, ByVal y As Double, ByVal z As Double)
Declare Sub glScissor       CDecl Alias "glScissor"     (ByVal x As Integer, ByVal y As Integer, ByVal width As Integer, ByVal height As Integer)
Declare Sub glTexCoord2f    CDecl Alias "glTexCoord2f"  (ByVal s As Single, ByVal t As Single)
Declare Sub glTexCoord3f    CDecl Alias "glTexCoord3f"  (ByVal s As Single, ByVal t As Single, ByVal u As Single)
Declare Sub glTexCoord4f    CDecl Alias "glTexCoord4f"  (ByVal s As Single, ByVal t As Single, ByVal u As Single, ByVal v As Single)
Declare Sub glTexImage2D    CDecl Alias "glTexImage2D"  (ByVal target As Integer, ByVal level As Integer, ByVal internalformat As Integer, ByVal width As Integer, ByVal height As Integer, ByVal border As Integer, ByVal format As Integer, ByVal ftype As Integer, ByVal pixels As Byte Ptr)
Declare Sub glTexSubImage2D CDecl Alias "glTexSubImage2D"(ByVal target As Integer, ByVal level As Integer, ByVal xoffset As Integer, ByVal yoffset As Integer, ByVal width As Integer, ByVal height As Integer, ByVal format As Integer, ByVal ftype As Integer, ByVal pixels As Byte Ptr)
Declare Sub glTranslatef    CDecl Alias "glTranslatef"  (ByVal x As Single, ByVal y As Single, ByVal z As Single)
Declare Sub glTranslated    CDecl Alias "glTranslated"  (ByVal x As Double, ByVal y As Double, ByVal z As Double)
Declare Sub glVertex3f      CDecl Alias "glVertex3f"    (ByVal x As Single, ByVal y As Single, ByVal z As Single)
Declare Sub glVertex4f      CDecl Alias "glVertex4f"    (ByVal x As Single, ByVal y As Single, ByVal z As Single, ByVal w As Single)
Declare Sub glViewport      CDecl Alias "glViewport"    (ByVal x As Integer, ByVal y As Integer, ByVal width As Integer, ByVal height As Integer)

Declare Sub glBindBufferUDI CDecl Alias "glBindBufferUDI"(ByVal target As Integer, ByVal name As Integer)

Const GL_COLOR_BUFFER_BIT   = &H00000001
Const GL_DEPTH_BUFFER_BIT   = &H00000002
Const GL_STENCIL_BUFFER_BIT = &H00000004
Const GL_ACCUM_BUFFER_BIT   = &H00000008

Const GL_POINTS         = &H00
Const GL_LINES          = &H01
Const GL_LINE_LOOP      = &H02
Const GL_LINE_STRIP     = &H03
Const GL_TRIANGLES      = &H04
Const GL_TRIANGLE_STRIP = &H05
Const GL_TRIANGLE_FAN   = &H06
Const GL_QUADS          = &H07
Const GL_QUAD_STRIP     = &H08
Const GL_POLYGON        = &H09


Const GL_COLOR_INDEX    = &HF0
Const GL_RED            = &HF1
Const GL_GREEN          = &HF2
Const GL_BLUE           = &HF3

Const GL_UNSIGNED_BYTE  = &H01
Const GL_BYTE           = &H02
Const GL_BITMAP         = &H03
Const GL_UNSIGNED_SHORT = &H04
Const GL_SHORT          = &H05
Const GL_UNSIGNED_INT   = &H06
Const GL_INT            = &H07
Const GL_FLOAT          = &H08

Const GL_MODELVIEW      = &H01
Const GL_PROJECTION     = &H02
Const GL_TEXTURE        = &H03

Const GL_ALPHA_TEST               = &H01
Const GL_AUTO_NORMAL              = &H02
Const GL_BLEND                    = &H03
Const GL_COLOR_LOGIC_OP           = &H04
Const GL_COLOR_MATERIAL           = &H05
Const GL_CULL_FACE                = &H06
Const GL_DEPTH_TEST               = &H07
Const GL_DITHER                   = &H08
Const GL_FOG                      = &H09
Const GL_INDEX_LOGIC_OP           = &H0A
Const GL_LIGHTING                 = &H0B
Const GL_LINE_SMOOTH              = &H0C
Const GL_LINE_STIPPLE             = &H0D
Const GL_MAP1_COLOR_4             = &H0E
Const GL_MAP1_INDEX               = &H0F
Const GL_MAP1_NORMAL              = &H10
Const GL_MAP1_TEXTURE_COORD_1     = &H11
Const GL_MAP1_TEXTURE_COORD_2     = &H12
Const GL_MAP1_TEXTURE_COORD_3     = &H13
Const GL_MAP1_TEXTURE_COORD_4     = &H14
Const GL_MAP1_VERTEX_3            = &H15
Const GL_MAP1_VERTEX_4            = &H16
Const GL_MAP2_COLOR_4             = &H17
Const GL_MAP2_INDEX               = &H18
Const GL_MAP2_NORMAL              = &H19
Const GL_MAP2_TEXTURE_COORD_1     = &H1A
Const GL_MAP2_TEXTURE_COORD_2     = &H1B
Const GL_MAP2_TEXTURE_COORD_3     = &H1C
Const GL_MAP2_TEXTURE_COORD_4     = &H1D
Const GL_MAP2_VERTEX_3            = &H1E
Const GL_MAP2_VERTEX_4            = &H1F
Const GL_NORMALIZE                = &H20
Const GL_POINT_SMOOTH             = &H21
Const GL_POLYGON_OFFSET_FILL      = &H22
Const GL_POLYGON_OFFSET_LINE      = &H23
Const GL_POLYGON_OFFSET_POINT     = &H24
Const GL_POLYGON_SMOOTH           = &H25
Const GL_POLYGON_STIPPLE          = &H26
Const GL_SCISSOR_TEST             = &H27
Const GL_STENCIL_TEST             = &H28
Const GL_TEXTURE_1D               = &H29
Const GL_TEXTURE_2D               = &H2A
Const GL_TEXTURE_GEN_Q            = &H2B
Const GL_TEXTURE_GEN_R            = &H2C
Const GL_TEXTURE_GEN_S            = &H2D
Const GL_TEXTURE_GEN_T            = &H2E
Const GL_BUFFER_2D                = &HA001

Const GL_PROXY_TEXTURE_2D   = &H02

Const GL_ALPHA              = &H05
Const GL_ALPHA4             = &H06
Const GL_ALPHA8             = &H07
Const GL_ALPHA12            = &H08
Const GL_ALPHA16            = &H09
Const GL_LUMINANCE          = &H0A
Const GL_LUMINANCE4         = &H0B
Const GL_LUMINANCE8         = &H0C
Const GL_LUMINANCE12        = &H0D
Const GL_LUMINANCE16        = &H0E
Const GL_LUMINANCE_ALPHA    = &H0F
Const GL_LUMINANCE4_ALPHA4  = &H10
Const GL_LUMINANCE6_ALPHA2  = &H11
Const GL_LUMINANCE8_ALPHA8  = &H12
Const GL_LUMINANCE12_ALPHA4 = &H13
Const GL_LUMINANCE12_ALPHA12= &H14
Const GL_LUMINANCE16_ALPHA16= &H15
Const GL_INTENSITY          = &H16
Const GL_INTENSITY4         = &H17
Const GL_INTENSITY8         = &H18
Const GL_INTENSITY12        = &H19
Const GL_INTENSITY16        = &H1A
Const GL_R3_G3_B2           = &H1B
Const GL_RGB                = &H1C
Const GL_RGB4               = &H1D
Const GL_RGB5               = &H1E
Const GL_RGB8               = &H1F
Const GL_RGB10              = &H20
Const GL_RGB12              = &H21
Const GL_RGB16              = &H22
Const GL_RGBA               = &H23
Const GL_RGBA2              = &H24
Const GL_RGBA4              = &H25
Const GL_RGB5_A1            = &H26
Const GL_RGBA8              = &H27
Const GL_RGB10_A2           = &H28
Const GL_RGBA12             = &H29
Const GL_RGBA16             = &H2A



#endif
