/* Summary: gl.h
 * Defines 3D functions
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
#ifndef _GL_GL_H
#define _GL_GL_H

#include "GL/gl_types.h"
#include "GL/mgl.h"

// OpenGL 1.0
#ifdef __CPLUSPLUS
extern "C" {
#endif



/*
./accum.html
./alphafunc.html
./aretexturesresident.html
./arrayelement.html */
    void glBegin        (GLenum);
/*
./bitmap.html
./blendcolorext.html
./blendfunc.html
./calllist.html
./calllists.html
*/
    void glClear        (GLbitfield);
/*
./clearaccum.html
*/
    void glClearColor   (GLclampf, GLclampf, GLclampf, GLclampf);
/*
./cleardepth.html
./clearindex.html
./clearstencil.html
./clipplane.html
*/
    void glColor3f      (GLfloat red, GLfloat green, GLfloat blue);
// color3*
    void glColor4f      (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
// color4*
/*
./colormask.html
./colorpointer.html
./copypixels.html
./copytexsubimage1d.html
./copytexsubimage2d.html
*/
    void glCullFace     (GLenum mode);
/*
./deletelists.html
./depthfunc.html
./depthmask.html
./depthrange.html
*/
    void glDisable      (GLenum cap);
/*
./drawbuffer.html
./drawelements.html
./drawpixels.html
./edgeflag.html
*/
    void glEnable       (GLenum cap);
/*
./enableclientstate.html
*/
    void glEnd          (void);
/*
./evalcoord.html
./evalmesh.html
./evalpoint.html
./feedbackbuffer.html
./finish.html
./flush.html
./fog.html
./frontface.html
*/
    void glFrustum      (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
/*
./genlists.html
./getclipplane.html
./geterror.html
./getlight.html
./getmaterial.html
./getpixelmap.html
./getpolygonstipple.html
*/
    GLubyte * glGetString (GLenum name);
/*
./gettexenv.html
./gettexgen.html
./getteximage.html
./hint.html
./indexmask.html
./indexpointer.html
./initnames.html
./interleavedarrays.html
./islist.html
./light.html
./lightmodel.html
./linestipple.html
./linewidth.html
./listbase.html
*/
    void glLoadIdentity (void);
/*
./loadmatrix.html
./loadname.html
./logicop.html
./map1.html
./map2.html
./mapgrid.html
./material.html
*/
    void glMatrixMode   (GLenum mode);
/*
./multmatrix.html
./normal.html
./ortho.html
./passthrough.html
./pixelmap.html
./pixelstore.html
./pixeltransfer.html
./pixelzoom.html
./pointsize.html
./polygonmode.html
./polygonstipple.html
./prioritizetextures.html
./pushattrib.html
./pushclientattrib.html
./pushmatrix.html
./pushname.html
./rasterpos.html
./readbuffer.html
./readpixels.html
./rect.html
./rendermode.html
*/
    void glRotatef      (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
    void glRotated      (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
    void glScalef       (GLfloat x,	GLfloat y, GLfloat z);
	void glScaled       (GLdouble x, GLdouble y, GLdouble z);
    void glScissor      (GLint x, GLint y, GLsizei width, GLsizei height);
/*
./selectbuffer.html
./shademodel.html
./stencilfunc.html
./stencilmask.html
./stencilop.html
*/
    void glTexCoord2f   (GLfloat s, GLfloat t);
// texcoord2*
    void glTexCoord3f   (GLfloat s, GLfloat t, GLfloat u);
// texcoord3*
    void glTexCoord4f   (GLfloat s, GLfloat t, GLfloat u, GLfloat v);
// texcoord4*
/*
./teximage1d.html
*/
    void glTexImage2D   (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
    void glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels );
    void glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels);
/*
./texgen.html
./texparameter.html
*/
    void glTranslatef   (GLfloat x, GLfloat y, GLfloat z);
    void glTranslated   (GLdouble x, GLdouble y, GLdouble z);

    void glVertex2f     (GLfloat x, GLfloat y);
//vertex2*
    void glVertex3f     (GLfloat x, GLfloat y, GLfloat z);
//vertex3*
    void glVertex4f     (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
//vertex4*
//vertex*v
    void glViewport     (GLint x, GLint y, GLsizei width, GLsizei height);

#ifdef __CPLUSPLUS
}
#endif

// Enumeration for glBegin
#define GL_POINTS                               0x0000
#define GL_LINES                                0x0001
#define GL_LINE_LOOP                            0x0002
#define GL_LINE_STRIP                           0x0003
#define GL_TRIANGLES                            0x0004
#define GL_TRIANGLE_STRIP                       0x0005
#define GL_TRIANGLE_FAN                         0x0006
#define GL_QUADS                                0x0007
#define GL_QUAD_STRIP                           0x0008
#define GL_POLYGON                              0x0009

// Bits for glClear
#define GL_COLOR_BUFFER_BIT   0x00000001
#define GL_DEPTH_BUFFER_BIT   0x00000002
#define GL_STENCIL_BUFFER_BIT 0x00000004
#define GL_ACCUM_BUFFER_BIT   0x00000008

// glCullFace
#define GL_FRONT                    0x0001
#define GL_BACK                     0x0002
#define GL_FRONT_AND_BACK           0x0003

// glEnable and glDisable
#define GL_ALPHA_TEST               0x0001
#define GL_AUTO_NORMAL              0x0002
#define GL_BLEND                    0x0003
//#define GL_CLIPi
#define GL_COLOR_LOGIC_OP           0x0004
#define GL_COLOR_MATERIAL           0x0005
#define GL_CULL_FACE                0x0006
#define GL_DEPTH_TEST               0x0007
#define GL_DITHER                   0x0008
#define GL_FOG                      0x0009
#define GL_INDEX_LOGIC_OP           0x000A
//#define GL_LIGHTi
#define GL_LIGHTING                 0x000B
#define GL_LINE_SMOOTH              0x000C
#define GL_LINE_STIPPLE             0x000D
#define GL_MAP1_COLOR_4             0x000E
#define GL_MAP1_INDEX               0x000F
#define GL_MAP1_NORMAL              0x0010
#define GL_MAP1_TEXTURE_COORD_1     0x0011
#define GL_MAP1_TEXTURE_COORD_2     0x0012
#define GL_MAP1_TEXTURE_COORD_3     0x0013
#define GL_MAP1_TEXTURE_COORD_4     0x0014
#define GL_MAP1_VERTEX_3            0x0015
#define GL_MAP1_VERTEX_4            0x0016
#define GL_MAP2_COLOR_4             0x0017
#define GL_MAP2_INDEX               0x0018
#define GL_MAP2_NORMAL              0x0019
#define GL_MAP2_TEXTURE_COORD_1     0x001A
#define GL_MAP2_TEXTURE_COORD_2     0x001B
#define GL_MAP2_TEXTURE_COORD_3     0x001C
#define GL_MAP2_TEXTURE_COORD_4     0x001D
#define GL_MAP2_VERTEX_3            0x001E
#define GL_MAP2_VERTEX_4            0x001F
#define GL_NORMALIZE                0x0020
#define GL_POINT_SMOOTH             0x0021
#define GL_POLYGON_OFFSET_FILL      0x0022
#define GL_POLYGON_OFFSET_LINE      0x0023
#define GL_POLYGON_OFFSET_POINT     0x0024
#define GL_POLYGON_SMOOTH           0x0025
#define GL_POLYGON_STIPPLE          0x0026
#define GL_SCISSOR_TEST             0x0027
#define GL_STENCIL_TEST             0x0028
#define GL_TEXTURE_1D               0x0029
#define GL_TEXTURE_2D               0x002A
#define GL_TEXTURE_GEN_Q            0x002B
#define GL_TEXTURE_GEN_R            0x002C
#define GL_TEXTURE_GEN_S            0x002D
#define GL_TEXTURE_GEN_T            0x002E
#define GL_BUFFER_2D                0xA001

// matrixmode
#define GL_MODELVIEW                0x0001
#define GL_PROJECTION               0x0002
#define GL_TEXTURE                  0x0003

// Input types for glTexImage*
#define GL_COLOR_INDEX                          0x00F0
#define GL_RED                                  0x00F1
#define GL_GREEN                                0x00F2
#define GL_BLUE                                 0x00F3
//#define GL_ALPHA
//#define GL_RGB
//#define GL_RGBA
//#define GL_LUMINANCE
//#define GL_LUMINANCE_ALPHA

// Input formats for glTexImage*
#define GL_UNSIGNED_BYTE                        0x0001
#define GL_BYTE                                 0x0002
#define GL_BITMAP                               0x0003
#define GL_UNSIGNED_SHORT                       0x0004
#define GL_SHORT                                0x0005
#define GL_UNSIGNED_INT                         0x0006
#define GL_INT                                  0x0007
#define GL_FLOAT                                0x0008

// Targets fo glTexImage2D
//#define GL_TEXTURE_2D                           0x0001
#define GL_PROXY_TEXTURE_2D                     0x0002

// glGetStrings
#define GL_VENDOR                               0x0001
#define GL_RENDERER                             0x0002
#define GL_VERSION                              0x0003
#define GL_EXTENSIONS                           0x0004


// OpenGL 1.1
/*
./bindtexture.html
./colormaterial.html
./copyteximage1d.html
./copyteximage2d.html
./deletetextures.html
./drawarrays.html
./edgeflagpointer.html
./gentextures.html
./get.html
./getmap.html
./getpointerv.html
./gettexlevelparameter.html
./gettexparameter.html
./index_.html
./isenabled.html
./istexture.html
./newlist.html
./normalpointer.html
./polygonoffset.html
./texcoordpointer.html
./texenv.html
./texsubimage1d.html
./texsubimage2d.html
./vertexpointer.html
*/


// Enumeration for glTexImage*
#define GL_ALPHA                                0x0005
#define GL_ALPHA4                               0x0006
#define GL_ALPHA8                               0x0007
#define GL_ALPHA12                              0x0008
#define GL_ALPHA16                              0x0009
#define GL_LUMINANCE                            0x000A
#define GL_LUMINANCE4                           0x000B
#define GL_LUMINANCE8                           0x000C
#define GL_LUMINANCE12                          0x000D
#define GL_LUMINANCE16                          0x000E
#define GL_LUMINANCE_ALPHA                      0x000F
#define GL_LUMINANCE4_ALPHA4                    0x0010
#define GL_LUMINANCE6_ALPHA2                    0x0011
#define GL_LUMINANCE8_ALPHA8                    0x0012
#define GL_LUMINANCE12_ALPHA4                   0x0013
#define GL_LUMINANCE12_ALPHA12                  0x0014
#define GL_LUMINANCE16_ALPHA16                  0x0015
#define GL_INTENSITY                            0x0016
#define GL_INTENSITY4                           0x0017
#define GL_INTENSITY8                           0x0018
#define GL_INTENSITY12                          0x0019
#define GL_INTENSITY16                          0x001A
#define GL_R3_G3_B2                             0x001B
#define GL_RGB                                  0x001C
#define GL_RGB4                                 0x001D
#define GL_RGB5                                 0x001E
#define GL_RGB8                                 0x001F
#define GL_RGB10                                0x0020
#define GL_RGB12                                0x0021
#define GL_RGB16                                0x0022
#define GL_RGBA                                 0x0023
#define GL_RGBA2                                0x0024
#define GL_RGBA4                                0x0025
#define GL_RGB5_A1                              0x0026
#define GL_RGBA8                                0x0027
#define GL_RGB10_A2                             0x0028
#define GL_RGBA12                               0x0029
#define GL_RGBA16                               0x002A

// MOS GL extentions

#ifdef __CPLUSPLUS
extern "C" {
#endif

    void glBindBufferUDI(GLenum target, GLuint buffer);
    void glBlitEXT(GLint srcx, GLint srcy, GLint dstx, GLint dsty, GLint width, GLint height);

#ifdef __CPLUSPLUS
}
#endif

#endif
