/* Summary: glx_opcodes.h
 * Defines the GLX encoding for 3D functions
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
#ifndef _GL_GLXOPCODES_H
#define _GL_GLXOPCODES_H

#include <GL/gl_types.h>

typedef struct _glx_stream_header
{
    GLshort len;
    GLshort opcode;
} _glx_stream_header;

void _glx_schedule(void *, int);
GLubyte * _glx_retrieve(GLsizei * length);

#define GLX_X_OPCODE 0

// short commands
#define GLOP_ACCUM 137
#define GLOP_ACTIVETEXTUREARB 197
#define GLOP_ALPHAFUNC 159
#define GLOP_BEGIN 4
#define GLOP_BINDTEXTURE 4117
#define GLOP_BLENDCOLOR 4096
#define GLOP_BLENDEQUATION 4097
#define GLOP_BLENDFUNC 160
#define GLOP_CALLLIST 1
#define GLOP_CLEAR 127
#define GLOP_CLEARACCUM 128
#define GLOP_CLEARCOLOR 130
#define GLOP_CLEARDEPTH 132
#define GLOP_CLEARINDEX 129
#define GLOP_CLEARSTENCIL 131
#define GLOP_CLIPPLANE 77
#define GLOP_COLOR3BV 6
#define GLOP_COLOR3DV 7
#define GLOP_COLOR3FV 8
#define GLOP_COLOR3IV 9
#define GLOP_COLOR3SV 10
#define GLOP_COLOR3UBV 11
#define GLOP_COLOR3UIV 12
#define GLOP_COLOR3USV 13
#define GLOP_COLOR4BV 14
#define GLOP_COLOR4DV 15
#define GLOP_COLOR4FV 16
#define GLOP_COLOR4IV 17
#define GLOP_COLOR4SV 18
#define GLOP_COLOR4UBV 19
#define GLOP_COLOR4UIV 20
#define GLOP_COLOR4USV 21
#define GLOP_COLORMASK 134
#define GLOP_COLORMATERIAL 78
#define GLOP_COLORTABLEPARAMETERFV 2054
#define GLOP_COLORTABLEPARAMETERIV 2055
#define GLOP_CONVOLUTIONPARAMETERF 4103
#define GLOP_CONVOLUTIONPARAMETERFV 4104
#define GLOP_CONVOLUTIONPARAMETERI 4105
#define GLOP_CONVOLUTIONPARAMETERIV 4106
#define GLOP_COPYCOLORSUBTABLE 196
#define GLOP_COPYCOLORTABLE 2056
#define GLOP_COPYCONVOLUTIONFILTER1D 4107
#define GLOP_COPYCONVOLUTIONFILTER2D 4108
#define GLOP_COPYPIXELS 172
#define GLOP_COPYTEXIMAGE1D 4119
#define GLOP_COPYTEXIMAGE2D 4120
#define GLOP_COPYTEXSUBIMAGE1D 4121
#define GLOP_COPYTEXSUBIMAGE2D 4122
#define GLOP_COPYTEXSUBIMAGE3D 4123
#define GLOP_CULLFACE 79
#define GLOP_DEPTHFUNC 164
#define GLOP_DEPTHMASK 135
#define GLOP_DEPTHRANGE 174
#define GLOP_DISABLE 138
#define GLOP_DRAWBUFFER 126
#define GLOP_EDGEFLAGV 22
#define GLOP_ENABLE 139
#define GLOP_END 23
#define GLOP_EVALCOORD1DV 151
#define GLOP_EVALCOORD1FV 152
#define GLOP_EVALCOORD2DV 153
#define GLOP_EVALCOORD2FV 154
#define GLOP_EVALMESH1 155
#define GLOP_EVALMESH2 157
#define GLOP_EVALPOINT1 156
#define GLOP_EVALPOINT2 158
#define GLOP_FOGF 80
#define GLOP_FOGFV 81
#define GLOP_FOGI 82
#define GLOP_FOGIV 83
#define GLOP_FRONTFACE 84
#define GLOP_FRUSTUM 175
#define GLOP_HINT 85
#define GLOP_HISTOGRAM 4110
#define GLOP_INDEXMASK 136
#define GLOP_INDEXDV 24
#define GLOP_INDEXFV 25
#define GLOP_INDEXIV 26
#define GLOP_INDEXSV 27
#define GLOP_INDEXUBV 194
#define GLOP_INITNAMES 121
#define GLOP_LIGHTMODELF 90
#define GLOP_LIGHTMODELFV 91
#define GLOP_LIGHTMODELI 92
#define GLOP_LIGHTMODELIV 93
#define GLOP_LIGHTF 86
#define GLOP_LIGHTFV 87
#define GLOP_LIGHTI 88
#define GLOP_LIGHTIV 89
#define GLOP_LINESTIPPLE 94
#define GLOP_LINEWIDTH 95
#define GLOP_LISTBASE 3
#define GLOP_LOADIDENTITY 176
#define GLOP_LOADMATRIXD 178
#define GLOP_LOADMATRIXF 177
#define GLOP_LOADNAME 122
#define GLOP_LOGICOP 161
#define GLOP_MAPGRID1D 147
#define GLOP_MAPGRID1F 148
#define GLOP_MAPGRID2D 149
#define GLOP_MAPGRID2F 150
#define GLOP_MATERIALF 96
#define GLOP_MATERIALFV 97
#define GLOP_MATERIALI 98
#define GLOP_MATERIALIV 99
#define GLOP_MATRIXMODE 179
#define GLOP_MINMAX 4111
#define GLOP_MULTMATRIXD 181
#define GLOP_MULTMATRIXF 180
#define GLOP_MULTITEXCOORD1DVARB 198
#define GLOP_MULTITEXCOORD1FVARB 199
#define GLOP_MULTITEXCOORD1IVARB 200
#define GLOP_MULTITEXCOORD1SVARB 201
#define GLOP_MULTITEXCOORD2DVARB 202
#define GLOP_MULTITEXCOORD2FVARB 203
#define GLOP_MULTITEXCOORD2IVARB 204
#define GLOP_MULTITEXCOORD2SVARB 205
#define GLOP_MULTITEXCOORD3DVARB 206
#define GLOP_MULTITEXCOORD3FVARB 207
#define GLOP_MULTITEXCOORD3IVARB 208
#define GLOP_MULTITEXCOORD3SVARB 209
#define GLOP_MULTITEXCOORD4DVARB 210
#define GLOP_MULTITEXCOORD4FVARB 211
#define GLOP_MULTITEXCOORD4IVARB 212
#define GLOP_MULTITEXCOORD4SVARB 213
#define GLOP_NORMAL3BV 28
#define GLOP_NORMAL3DV 29
#define GLOP_NORMAL3FV 30
#define GLOP_NORMAL3IV 31
#define GLOP_NORMAL3SV 32
#define GLOP_ORTHO 182
#define GLOP_PASSTHROUGH 123
#define GLOP_PIXELTRANSFERF 166
#define GLOP_PIXELTRANSFERI 167
#define GLOP_PIXELZOOM 165
#define GLOP_POINTSIZE 100
#define GLOP_POLYGONMODE 101
#define GLOP_POLYGONOFFSET 192
#define GLOP_POPATTRIB 141
#define GLOP_POPMATRIX 183
#define GLOP_POPNAME 124
#define GLOP_PRIORITIZETEXTURES 4118
#define GLOP_PUSHATTRIB 142
#define GLOP_PUSHMATRIX 184
#define GLOP_PUSHNAME 125
#define GLOP_RASTERPOS2DV 33
#define GLOP_RASTERPOS2FV 34
#define GLOP_RASTERPOS2IV 35
#define GLOP_RASTERPOS2SV 36
#define GLOP_RASTERPOS3DV 37
#define GLOP_RASTERPOS3FV 38
#define GLOP_RASTERPOS3IV 39
#define GLOP_RASTERPOS3SV 40
#define GLOP_RASTERPOS4DV 41
#define GLOP_RASTERPOS4FV 42
#define GLOP_RASTERPOS4IV 43
#define GLOP_RASTERPOS4SV 44
#define GLOP_READBUFFER 171
#define GLOP_RECTDV 45
#define GLOP_RECTFV 46
#define GLOP_RECTIV 47
#define GLOP_RECTSV 48
#define GLOP_RESETHISTOGRAM 4112
#define GLOP_RESETMINMAX 4113
#define GLOP_ROTATED 185
#define GLOP_ROTATEF 186
#define GLOP_SCALED 187
#define GLOP_SCALEF 188
#define GLOP_SCISSOR 103
#define GLOP_SHADEMODEL 104
#define GLOP_STENCILFUNC 162
#define GLOP_STENCILMASK 133
#define GLOP_STENCILOP 163
#define GLOP_TEXCOORD1DV 49
#define GLOP_TEXCOORD1FV 50
#define GLOP_TEXCOORD1IV 51
#define GLOP_TEXCOORD1SV 52
#define GLOP_TEXCOORD2DV 53
#define GLOP_TEXCOORD2FV 54
#define GLOP_TEXCOORD2IV 55
#define GLOP_TEXCOORD2SV 56
#define GLOP_TEXCOORD3DV 57
#define GLOP_TEXCOORD3FV 58
#define GLOP_TEXCOORD3IV 59
#define GLOP_TEXCOORD3SV 60
#define GLOP_TEXCOORD4DV 61
#define GLOP_TEXCOORD4FV 62
#define GLOP_TEXCOORD4IV 63
#define GLOP_TEXCOORD4SV 64
#define GLOP_TEXENVF 111
#define GLOP_TEXENVFV 112
#define GLOP_TEXENVI 113
#define GLOP_TEXENVIV 114
#define GLOP_TEXGEND 115
#define GLOP_TEXGENDV 116
#define GLOP_TEXGENF 117
#define GLOP_TEXGENFV 118
#define GLOP_TEXGENI 119
#define GLOP_TEXGENIV 120
#define GLOP_TEXPARAMETERF 105
#define GLOP_TEXPARAMETERFV 106
#define GLOP_TEXPARAMETERI 107
#define GLOP_TEXPARAMETERIV 108
#define GLOP_TRANSLATED 189
#define GLOP_TRANSLATEF 190
#define GLOP_VERTEX2DV 65
#define GLOP_VERTEX2FV 66
#define GLOP_VERTEX2IV 67
#define GLOP_VERTEX2SV 68
#define GLOP_VERTEX3DV 69
#define GLOP_VERTEX3FV 70
#define GLOP_VERTEX3IV 71
#define GLOP_VERTEX3SV 72
#define GLOP_VERTEX4DV 73
#define GLOP_VERTEX4FV 74
#define GLOP_VERTEX4IV 75
#define GLOP_VERTEX4SV 76
#define GLOP_VIEWPORT 191

// long commands
#define GLOP_BITMAP 5
#define GLOP_CALLLISTS 2
#define GLOP_COLORTABLE 2053
#define GLOP_COLORSUBTABLE 195
#define GLOP_CONVOLUTIONFILTER1D 4101
#define GLOP_CONVOLUTIONFILTER2D 4102
#define GLOP_DRAWARRAYS 193
#define GLOP_DRAWPIXELS 173
#define GLOP_PIXELMAPFV 168
#define GLOP_PIXELMAPUIV 169
#define GLOP_PIXELMAPUSV 170
#define GLOP_MAP1D 143
#define GLOP_MAP1F 144
#define GLOP_MAP2F 145
#define GLOP_MAP2D 146
#define GLOP_POLYGONSTIPPLE 102
#define GLOP_SEPARABLEFILTER2D 4109
#define GLOP_TEXIMAGE1D 109
#define GLOP_TEXIMAGE2D 110
#define GLOP_TEXIMAGE3D 4114
#define GLOP_TEXSUBIMAGE1D 4099
#define GLOP_TEXSUBIMAGE2D 4100
#define GLOP_TEXSUBIMAGE3D 4115

// GLX commands
#define GLXOP_ARETEXTURESRESIDENT        143
#define GLXOP_DELETELISTS                103
#define GLXOP_DELETETEXTURES             144
#define GLXOP_ENDLIST                    102
#define GLXOP_FEEDBACKBUFFER             105
#define GLXOP_FINISH                     108
#define GLXOP_FLUSH                      142
#define GLXOP_GENLISTS                   104
#define GLXOP_GENTEXTURES                145
#define GLXOP_GETBOOLEANV                112
#define GLXOP_GETCLIPPLANE               113
#define GLXOP_GETCOLORTABLE              147
#define GLXOP_GETCOLORTABLEPARAMETERFV   148
#define GLXOP_GETCOLORTABLEPARAMETERIV   149
#define GLXOP_GETCOMPRESSEDTEXIMAGE      160
#define GLXOP_GETCONVOLUTIONFILTER       150
#define GLXOP_GETCONVOLUTIONPARAMETERFV  151
#define GLXOP_GETCONVOLUTIONPARAMETERIV  152
#define GLXOP_GETDOUBLEV                 114
#define GLXOP_GETERROR                   115
#define GLXOP_GETFLOATV                  116
#define GLXOP_GETHISTOGRAM               154
#define GLXOP_GETHISTOGRAMPARAMETERFV    155
#define GLXOP_GETHISTOGRAMPARAMETERIV    156
#define GLXOP_GETINTEGERV                117
#define GLXOP_GETLIGHTFV                 118
#define GLXOP_GETLIGHTIV                 119
#define GLXOP_GETMAPDV                   120
#define GLXOP_GETMAPFV                   121
#define GLXOP_GETMAPIV                   122
#define GLXOP_GETMATERIALFV              123
#define GLXOP_GETMATERIALIV              124
#define GLXOP_GETMINMAX                  157
#define GLXOP_GETMINMAXPARAMETERFV       158
#define GLXOP_GETMINMAXPARAMETERIV       159
#define GLXOP_GETPIXELMAPFV              125
#define GLXOP_GETPIXELMAPUIV             126
#define GLXOP_GETPIXELMAPUSV             127
#define GLXOP_GETPOLYGONSTIPPLE          128
#define GLXOP_GETSEPARABLEFILTER         153
#define GLXOP_GETSTRING                  129
#define GLXOP_GETTEXENVFV                130
#define GLXOP_GETTEXENVIV                131
#define GLXOP_GETTEXENVDV                132
#define GLXOP_GETTEXGENFV                133
#define GLXOP_GETTEXGENIV                134
#define GLXOP_GETTEXIMAGE                135
#define GLXOP_GETTEXPARAMETERFV          136
#define GLXOP_GETTEXPARAMETERIV          137
#define GLXOP_GETTEXLEVELPARAMETERFV     138
#define GLXOP_GETTEXLEVELPARAMETERIV     139
#define GLXOP_ISENABLED                  140
#define GLXOP_ISLIST                     141
#define GLXOP_ISTEXTURE                  146
#define GLXOP_NEWLIST                    101
#define GLXOP_PIXELSTOREF                109
#define GLXOP_PIXELSTOREI                110
#define GLXOP_READPIXELS                 111
#define GLXOP_RENDERMODE                 107
#define GLXOP_SELECTBUFFER               106



// Getters

// Todo: insert opcodes for GLX get* functions



// mgl commands

// Fixme: allocate proper indices
#define GLOP_SWAPBUFFER 4000
#define GLOP_BINDBUFFERUDI 0x7001
#define GLOP_BLITUDI 0x7002
#define GLOP_BLITFILLUDI 0x7003

#endif
