'
' Summary: adt.bi
' *Defines the classes that are part of the datastructure library*
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mcobject.bi"

Type MCLinkedListItem Extends MCObject
    mContents As MCObject Ptr
    mNextitem As MCLinkedListItem Ptr
    Declare Constructor()
    Declare Constructor(ByVal contents As MCObject Ptr)
    Declare Destructor()
End Type

Declare Function MCLinkedListItemCreate(ByVal contents As MCObject Ptr) As MCLinkedListItem Ptr

Type MCLinkedList Extends MCObject
    mFirstitem As MCLinkedListItem Ptr
    mLastitem As MCLinkedListItem Ptr
    mCount As Integer

    Declare Sub PushFront(ByVal item as MCObject Ptr)
    Declare Sub PushBack(ByVal item as MCObject Ptr)
    Declare Function PeekFront() as MCObject Ptr
    Declare Function PeekBack() as MCObject Ptr
    Declare Function GetAtIndex(ByVal index as Integer) as MCObject Ptr
    Declare Sub InsertAtIndex(ByVal item as MCObject Ptr, ByVal index as Integer)
    Declare Function PopFront() as MCObject Ptr
    Declare Function PopBack() as MCObject Ptr
    Declare Sub RemoveFront()
    Declare Sub RemoveBack()
    Declare Sub RemoveAtIndex(ByVal index as Integer)
    Declare Constructor ()
    Declare Destructor()
End Type

Type MCHashable Extends MCObject
    mHashCode As Function(ByVal thispointer as MCHashable Ptr) As Unsigned Integer
    mEquals As Function(ByVal thispointer as MCHashable Ptr, ByVal otherpointer as MCHashable Ptr) As Integer
    Declare Constructor()
End Type

Type MCKeyValuePair Extends MCObject
    mKey As MCHashable Ptr
    mValue As MCObject Ptr

    Declare Destructor()
    Declare Constructor(ByVal key As MCHashable Ptr, ByVal value As MCObject Ptr)
End Type

Type MCHashMap Extends MCObject
    mHashmap As MCLinkedListItem Ptr Ptr
    mMaplen As Integer
    mCountlen As Integer
    
    Declare Sub Insert(ByVal key as MCHashable Ptr, ByVal value as MCObject Ptr)
    Declare Sub InsertPair(ByVal pair As MCKeyValuePair Ptr)
    Declare Function Find(ByVal key As MCHashable Ptr) As MCObject Ptr
    Declare Function FindPair(ByVal key As MCHashable Ptr) As MCKeyValuePair Ptr
    Declare Function Exists(ByVal key as MCHashable Ptr) As Integer
    Declare Sub Remove(ByVal key As MCHashable Ptr)

    Declare Sub Resize(ByVal size As Integer)

    Declare Constructor()
    Declare Destructor()
End Type

Extern Basepool As MCObject Ptr
