'
' Summary: ast.bi
' Contains the definitions of the abstract syntax tree representing the 
'   graphics driver operation
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#ifndef _LIBGFX_AST_BI
#define _LIBGFX_AST_BI

Type AST_RawOpcodeMap
    length As Integer
    data As Integer Ptr
End Type

Type AST_Graphics
    opcode As Integer
    operands As Integer
    operand as AST_Graphics Ptr Ptr
    customdata As Byte Ptr
    valid As Integer
    'GetValue As Function(node as AST_Graphics Ptr) As Integer
End Type

Type AST_Node
    children As AST_Node Ptr Ptr
    childcount As Integer
    refcount As Integer
    visited As Integer
    operatorindex As Integer
    opcode As Unsigned Integer
    const1 As Unsigned Integer
    const2 As Unsigned Integer
    const3 As Unsigned Integer
End Type

Declare Function LibGFX_RetrieveMap CDecl Alias "LibGFX_RetrieveMap" (ByVal engine As Integer) As AST_RawOpcodeMap Ptr
Declare Sub LibGFX_DeleteMap CDecl Alias "LibGFX_DeleteMap" (ByVal map As AST_RawOpcodeMap Ptr)
Declare Function LibGFX_BuildTree CDecl Alias "LibGFX_BuildTree" (ByVal map As AST_RawOpcodeMap Ptr) As AST_Node Ptr
Declare Sub LibGFX_FreeNode CDecl Alias "LibGFX_FreeNode" (ByVal node As AST_Node Ptr)

Declare Function LibGFX_CloneTree CDecl Alias "LibGFX_CloneTree" (ByVal root As AST_Node Ptr) As AST_Node Ptr

Declare Function LibGFX_UnfoldMad CDecl Alias "LibGFX_UnfoldMad" (ByVal root As AST_Node Ptr) As Integer
Declare Function LibGFX_TreeSubstOffset CDecl Alias "LibGFX_TreeSubstOffset" (ByVal root As AST_Node Ptr) As AST_Node Ptr
Declare Function LibGFX_TreeSubstOffsetPrime CDecl Alias "LibGFX_TreeSubstOffsetPrime" (ByVal root as AST_Node Ptr, ByVal stateindex As Integer Ptr, ByVal attrindex1 As Integer Ptr, ByVal attrindex2 As Integer Ptr, ByVal stateattrmul As Integer Ptr, ByVal statemul As Integer Ptr, ByVal attrmul1 As Integer Ptr, ByVal attrmul2 As Integer Ptr, ByVal add As Integer Ptr) As AST_Node Ptr
'void * LibGFX_CopyLinearOffsetData(void * in);
Declare Function LibGFX_TreeSubstFramebuffer CDecl Alias "LibGFX_TreeSubstFramebuffer" (ByVal root As AST_Node Ptr) As Integer
'void *              LibGFX_CopyFramebufferData(void * in);
Declare Function LibGFX_PrintNode CDecl Alias "LibGFX_PrintNode" (ByVal root as AST_Node Ptr, ByVal base As Byte Ptr, ByVal maxbytes As Integer) As Integer

#endif
