/*
    Summary: ast.h
    *Definition of the libgfx syntax trees*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */
#ifndef __LIBGFX_AST_H__
#define __LIBGFX_AST_H__

#include <stdint.h>

typedef struct AST_RawOpcodeMap
{
    uint32_t length;
    uint32_t * data;
} AST_RawOpcodeMap;


typedef struct AST_Node
{
    struct AST_Node ** children;
    int childcount;
    int refcount;
    int visited;
    int operatorindex;
    uint32_t opcode;
    uint32_t const1;
    uint32_t const2;
    uint32_t const3;
    void * data;
    void (*freedata)(void*);
    void * (*clonedata)(void*);
} AST_Node;

typedef struct AST_LinearOffsetData
{
    int xarg;
    int xscaleattr;
    int xmulargscale;
    int xmularg;
    int xmulscale;
    int yarg;
    int yscaleattr;
    int ymulargscale;
    int ymularg;
    int ymulscale;
    int offsetattr;
    int offsetscale;
    int baseoffset;
    int buffersize;
} AST_LinearOffsetData;

typedef struct AST_FramebufferData
{
    AST_LinearOffsetData offset;
    int bufferindexattr;
    int bufferindexconst;
    int bufferbits;
} AST_FramebufferData;

typedef struct AST_Bit
{
    int currentbit;
    int sourcebit;
    AST_Node * source_node;
    struct AST_Bit * next_bit;
} AST_Bit;


// opcodes outside the UDI range
#define AST_OPCODE_ADDRGEN      0x2000
#define AST_OPCODE_FRAMEBUFFER  0x2001

extern AST_Node libgfx_nullnode;

AST_RawOpcodeMap *  LibGFX_RetrieveMap      (uint32_t engine);
void                LibGFX_DeleteMap        (AST_RawOpcodeMap * map);
AST_Node *          LibGFX_BuildTree        (AST_RawOpcodeMap * map);
void                LibGFX_FreeNode         (AST_Node * node);
AST_Node *          LibGFX_CloneTree        (AST_Node * root);
void                LibGFX_FreeBitlist      (AST_Bit * root);

int                 LibGFX_UnfoldMad        (AST_Node * root);
AST_Node *          LibGFX_TreeSubstOffset  (AST_Node * root);
AST_Node *          LibGFX_TreeSubstOffsetPrime(AST_Node * root, int * stateindex, int * attrindex1, int * attrindex2, int * stateattrmul, int * statemul, int * attrmul1, int * attrmul2, int * add);
void *              LibGFX_CopyLinearOffsetData(void * in);
int                 LibGFX_TreeSubstFramebuffer(AST_Node * root);
void *              LibGFX_CopyFramebufferData(void * in);
int                 LibGFX_PrintNode        (AST_Node * root, char * base, int maxbytes);
int                 LibGFX_ConstAttrFold    (AST_Node * root, int * const_val, int * attr_val);
int                 LibGFX_BufferBitFold    (AST_Node * root, AST_Bit ** bitout, int allowapprox);
#endif
