/*
    Summary: template.h
    *Definition of the libgfx mode templates*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */
#ifndef __LIBGFX_TEMPLATE_H__
#define __LIBGFX_TEMPLATE_H__

#include <stdint.h>
#include <libgfx/ast.h>

#define TEMPLATE_SFRAMEBUFFER 1

typedef struct TPL_PackedFramebuffer
{
    uint8_t red_bits;
    uint8_t red_shift;
    uint8_t green_bits;
    uint8_t green_shift;
    uint8_t blue_bits;
    uint8_t blue_shift;
    uint8_t alpha_bits;
    uint8_t alpha_shift;
    uint32_t framebuffer_const;
    uint32_t framebuffer_attr;
    uint8_t x_per_tile;
    uint8_t y_per_tile;
    uint8_t bitsperpixel;
    uint8_t bitsperentry;
} TPL_PackedFramebuffer;

typedef struct TPL_Config
{
    uint32_t input;
    uint32_t outputattr;
    int32_t nominator;
    int32_t denominator;
    int32_t preadd;
    int32_t postadd;
} TPL_Config;


typedef struct TPL_ModeTemplate
{
    int32_t templatetype;
    TPL_Config * setup;
    uint32_t setupcount;
    union
    {
        TPL_PackedFramebuffer pfb;
    } info;

} TPL_ModeTemplate;

TPL_ModeTemplate *      LibGFX_MatchPackedFramebuffer       (AST_Node * tree);

#endif
