'
' Summary: mcobject.bi
' *Defines the semi-managed class*
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'


' Class: MCObject
' Provides basic memory functionality for the library 
Type MCObject Extends Object
    ' Variable: mRefcount
    ' Contains the amount of pending references.
    ' This field is one at initialisation, and the object
    ' will be deleted when its value reaches zero.
    mRefcount As Integer

    ' Variable: mAutocount
    ' Amount of non-ownership references to this object.
    ' Software should always use a non-ownership reference 
    ' when passing an MCObject type as a return value
    mAutocount As Integer

    ' Variable: mAutoNext
    ' Pointer to the next object with an autorelease count
    ' This pointer forms a linked list of all objects which have 
    ' a pending release
    mAutoNext As MCObject Ptr
    
    Declare Constructor()
    Declare Destructor()

    ' Function: Retain
    ' Claim (co-)ownership of an object    
    Declare Sub Retain()
    ' Function: Release
    ' Release ownership of an object
    Declare Sub Release()
    ' Function: Autorelease
    ' Release ownership of an object, while keeping it temporarily
    ' alive for a calling function to reacquire ownership
    Declare Sub Autorelease()
    
    ' Function: Flush
    ' Called by a memory management tool to inform that there are
    ' no stack references left in use. Must not be called by 
    ' application code.
    Declare Sub Flush()
End Type

Declare Function MCToPointer CDecl Alias "MCPointerConv" (ByVal data As MCObject Ptr) As Byte Ptr
Declare Function MCFromPointer CDecl Alias "MCPointerConv" (ByVal data As Byte Ptr) As MCObject Ptr

