' Summary: bga_regs.bi
' BGA Registers
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'


Declare Sub BGA_Write(ByVal index As Integer, ByVal contents As Unsigned Short)
Declare Function BGA_Read(ByVal index As Integer) As Unsigned Short


' Constant: BGA_INDEX_PORT
' The default offset for the 16-bit BGA index port
Const BGA_INDEX_PORT = &H1CE

' Constant: BGA_DATA_PORT
' The default offset for the 16-bit BGA data port
Const BGA_DATA_PORT = &H1CF

' Enumeration: bga_regs
' Lists all the registers of the BGA interface
Enum bga_regs
    ' Constant: INDEX_ID
    ' 16-bit register containing the emulated interface version
    '
    ' Normally takes values in the range 0xB0C0-0xB0C4
    ' (at the time of writing). You can write a different
    ' value to set a different emulation. If the number is invalid
    ' the register is left unchanged 
    '
    ' Note that bochs will panic with a wrong number because it
    ' thinks the VGA bios doesn't match with the interface.
    INDEX_ID = 0

    INDEX_XRES = 1
    INDEX_YRES = 2
    INDEX_BPP = 3
    INDEX_ENABLE = 4
    INDEX_BANK = 5
    INDEX_VIRT_WIDTH = 6
    INDEX_VIRT_HEIGHT = 7
    INDEX_X_OFFSET = 8
    INDEX_Y_OFFSET = 9
End Enum


'Enumeration: bga_regs_enable
'Bitmasks for the <bga_regs.INDEX_ENABLE> register
Enum bga_regs_enable

    BGA_OUTPUT_ENABLED = &H01

    BGA_LFB_ENABLED = &H40
    BGA_NOCLEARMEM = &H80
End Enum
