' Summary: block.bi
' Contains the message interface for block devices
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

Const BLOCKCOMMANDBASE = &H50000

' Enumeration: BLOCKDRIVERCOMMANDS
' Lists the commands supported by block-oriented devices
Enum BLOCKDRIVERCOMMANDS
    BLOCKDRIVERCOMMAND_GEOM = BLOCKCOMMANDBASE + 0
    BLOCKDRIVERCOMMAND_READ = BLOCKCOMMANDBASE + 1
    BLOCKDRIVERCOMMAND_WRITE = BLOCKCOMMANDBASE + 2
    'BLOCKDRIVERCOMMAND_DATA = BLOCKCOMMANDBASE + 3

    '16: <command> <(4)request no> <(8) size>
    BLOCKDRIVERCOMMAND_ADDMAP = BLOCKCOMMANDBASE + 4
    
    '12: <command> <request no> <map>
    BLOCKDRIVERCOMMAND_DELMAP = BLOCKCOMMANDBASE + 5
    
    '40: <command> <request no> <(4) source map> <(8) source start> <(4) dest map> <(8) dest start> <(8) size>
    BLOCKDRIVERCOMMAND_SETEXTENT = BLOCKCOMMANDBASE + 6
    
    '20: <command> <request no> <number> <(8) size>
    BLOCKDRIVERCOMMAND_NEWMAP = BLOCKCOMMANDBASE + 7

End Enum

Enum BLOCKCLIENTCOMMANDS
    BLOCKCLIENTCOMMAND_DATA = BLOCKCOMMANDBASE + 16
End Enum
