'
' Summary: channel.bi
' Main definitions of the channel wrapper code
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#ifndef _CHANNEL_BI
#define _CHANNEL_BI

#include "mcobject.bi"
#include "event.bi"

Type MCChannelListener Extends MCObject 
    Declare Function Start() As Integer
    Declare Sub SetHandler(ByVal index As Integer, ByVal handler As Function CDecl(ByVal thisptr As MCChannelListener Ptr, ByVal sender As Integer, ByVal length As Integer, ByVal contents As Byte Ptr) As Integer)
    Declare Function GetHandlerPointer() As MOS_EVENTHANDLER Ptr
    Declare Constructor()
    Declare Destructor()
End Type

Type MCFSDriverListener Extends MCChannelListener
    Declare Constructor()
    Declare Destructor()
    Declare Sub MountReq(ByVal sender As Integer, ByVal requestId As Integer)
    Declare Sub UnmountReq(ByVal sender As Integer, ByVal requestId As Integer)
    Declare Sub StatReq(ByVal sender As Integer, ByVal requestId As Integer, ByRef volumepath As String)
End Type

Type MCFSClientListener Extends MCChannelListener
    Declare Constructor()
    Declare Destructor()
    Declare Sub MountAck(ByVal sender As Integer, ByVal requestId As Integer)
    Declare Sub MountNak(ByVal sender As Integer, ByVal requestId As Integer)
    Declare Sub StatAck(ByVal sender As Integer, ByVal requestId As Integer, ByVal flags As Integer, ByVal Filesize As Long, ByVal Disksize As Long, ByRef volumepath As String)
End Type

Type MCBlockDriverListener Extends MCChannelListener
    Declare Constructor()
    Declare Destructor()
End Type

Type MCBlockClientListener Extends MCChannelListener
    Declare Constructor()
    Declare Destructor()
End Type

#endif
