/*
        Summary: event.h
        *The header file for the microkernel event handling routines*

        Author:
            Marcel Sondaar

        License:
            Public Domain
*/
#ifndef MOS_EVENT_H
#define MOS_EVENT_H

#include <stdint.h>
#include <stdlib.h>

typedef struct MOS_EVENTHANDLER
{
    int (*callback)(void *, unsigned int, unsigned int, unsigned char *);
    void * data;
} MOS_EVENTHANDLER;

typedef struct MOS_EVENTHANDLER_TREE
{
    uint32_t max_message_sub;
    MOS_EVENTHANDLER * handles;
} MOS_EVENTHANDLER_TREE;

typedef struct MOS_EVENTHANDLER_ROOT
{
    uint32_t max_roots;
    MOS_EVENTHANDLER_TREE * sys_trees;
    MOS_EVENTHANDLER_TREE * user_tree;
    int (*errorhandler)(unsigned int, unsigned int, unsigned char *);
} MOS_EVENTHANDLER_ROOT;

extern MOS_EVENTHANDLER_ROOT * mos_eventhandles; 

extern void * (*eventdata_alloc)(size_t);
extern void (*eventdata_free)(void *);

int mos_defaulteventerror(unsigned int, unsigned int, unsigned char *);

int mos_eventloop(void);
int mos_eventloop_prime(MOS_EVENTHANDLER_ROOT *);

void mos_resize_insert(MOS_EVENTHANDLER_ROOT *, uint32_t slot, int (*callback)(void *, unsigned int, unsigned int, unsigned char *), void * data);

#endif
