' Summary: mach64_id.bas
' Some Mach64-related constants
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

' Enumeration: Mach64_devids
' Lists the PCI Device IDs that are based on the mach64 core.
'
' Currently this list is short because there are minor differences
' between '64s that can break drivers, and the code hasn't been
' tested thoroughly
Enum Mach64_devids
    RAGE_PRO_1 = &H4742    ' Rage Pro, AGP

    RAGE_XL_1  = &H4752    ' Rage XL, PCI

    RAGE_IIC_1 = &H4756	   ' RAGE IIC, PCI
    RAGE_IIC_2 = &H4757	   ' RAGE IIC, AGP
    RAGE_IIC_3 = &H475A	   ' RAGE IIC, AGP
End Enum

' Enumeration: Mach64_regs
' A list of the Mach64 registers
' Note: some registers may not be present on all controllers,
' and some may be missing altogether.
Enum Mach64_regs

  ' CRTC registers

    ' Constant: CRTC_H_TOTAL_DISP
    ' 32-bit register holding the horizontal counter settings
    '
    ' documented in vgadoc
    CRTC_H_TOTAL_DISP = &H00
    ' Constant: CRTC_H_SYNC_STRT_WID
    ' 32-bit register holding the hsync pulse settings
    '
    ' documented in vgadoc
    CRTC_H_SYNC_STRT_WID = &H04
    ' Constant: CRTC_V_TOTAL_DISP
    ' 32-bit register holding the vertical counter settings
    '
    ' documented in vgadoc
    CRTC_V_TOTAL_DISP = &H08
    ' Constant: CRTC_V_SYNC_STRT_WID
    ' 32-bit register holding the vsync pulse settings
    '
    ' documented in vgadoc
    CRTC_V_SYNC_STRT_WID = &H0C
    ' Constant: CRTC_VLINE_CRNT_VLINE
    ' 32-bit register holding the current vertical counter and reference counter.
    '
    ' documented in vgadoc
    CRTC_VLINE_CRNT_VLINE = &H10
    ' Constant: CRTC_OFF_PITCH
    ' 32-bit register holding the screen offset and virtual width
    '
    ' documented in vgadoc
    CRTC_OFF_PITCH = &H14
    ' Constant: CRTC_GEN_CNTL
    ' 32-bit register for general CRTC configuration.
    '
    ' documented in vgadoc. See <Mach64_crtc_gen_cntl>
    CRTC_GEN_CNTL = &H1C

  ' DSP registers

    ' Constant: DSP_CONFIG
    ' 32-bit register for the DSP (undocumented)
    '
    ' bits 00-15 - dsp_xclks
    ' bits 16-19 - dsp_loop_latency
    ' bits 20-31 - dsp_precision
    DSP_CONFIG = &H20
    ' Constant: DSP_ON_OFF
    ' 32-bit register for the DSP (undocumented)
    '
    ' bits 00-15 - dsp_off
    ' bits 16-32 - dsp_on
    DSP_ON_OFF = &H24

  ' Overscan registers

    ' Constant: OVR_WID_LEFT_RIGHT
    ' 32-bit register holding the size of the horizontal overscan area
    '
    ' documented in vgadoc
    OVR_WID_LEFT_RIGHT = &H44
    ' Constant: OVR_WID_TOP_BOTTOM
    ' 32-bit register holding the size of the vertical overscan area
    '
    ' documented in vgadoc
    OVR_WID_TOP_BOTTOM = &H48

  ' Clock generator registers

    ' Constant: CLOCK_CNTL
    ' 8-bit register for external clock control.
    '
    ' VGADOC disagrees and labels it 32 bit which is technically wrong.
    ' It will probably work happily on a 88800GX though
    '
    ' more info on this register as found in 88800s is in VGADOC
    '
    ' it seems that on integrated versions this is used for selecting the CRTC clock
    CLOCK_CNTL = &H90
    ' Constant: CLOCK_CNTL_ADDR
    ' 8-bit register for addressing a register of the integrated clock generator (undocumented)
    '
    ' bit 0   - Undefined
    ' bit 1   - Start write cycle. Set this bit prior to write,
    '           write the data to <CLOCK_CNTL_DATA>,
    '           then reload this register with the bit cleared again.
    ' bit 2-7 - Clock register index. See <Mach64_clock_regs>
    CLOCK_CNTL_ADDR = &H91
    ' Constant: CLOCK_CNTL_DATA
    ' 8-bit register for accessing a register of the integrated clock generator (undocumented)
    '
    ' bit 0-7 - data bits
    CLOCK_CNTL_DATA = &H92

  ' ASIC configuration

    ' Constant: BUS_CNTL
    ' 32-bit register for configuring the internal and external buses
    '
    ' documented in vgadoc
    BUS_CNTL = &HA0
    ' Constant: EXT_MEM_CNTL
    ' 32-bit register for memory configuration
    '
    ' *not* documented, set by linux for all later Mach64s. Only written
    ' with magic values.
    EXT_MEM_CNTL = &HAC
    ' Constant: MEM_CNTL
    ' 32-bit register for memory configuration
    '
    ' partially documented in vgadoc, partially undocumented.
    MEM_CNTL = &HB0

  ' VGA memory accesses

    MEM_VGA_WP_SEL = &HB4
    MEM_VGA_RP_SEL = &HB8

  ' DAC registers

    ' Constant: DAC_W_INDEX
    ' 8-bit register for selecting the DAC entry to write to.
    '
    ' Mirrors the corresponding VGA register.
    DAC_W_INDEX = &HC0
    ' Constant: DAC_DATA
    ' 8-bit register for reading/writing the contents of the DAC
    '
    ' Mirrors the corresponding VGA register.
    DAC_DATA = &HC1
    ' Constant: DAC_MASK
    ' 8-bit register containing the mask to be applied to color indices prior to lookup in the DAC
    '
    ' Mirrors the corresponding VGA register.
    DAC_MASK = &HC2
    ' Constant: DAC_R_INDEX
    ' 8-bit register for selecting the DAC entry to read from.
    '
    ' Mirrors the corresponding VGA register.
    DAC_R_INDEX = &HC3
    ' Constant: DAC_CNTL
    ' 32-bit register for general DAC configuration
    '
    ' partially documented in vgadoc, partially undocumented.
    DAC_CNTL = &HC4

  ' Engine control

    ' Constant: GEN_TEST_CNTL
    ' 32-bit register for general engine and test settings.
    GEN_TEST_CNTL = &HD0



  ' GUI engine

    DST_OFF_PITCH = &H100
    DST_Y_X = &H10C
    DST_WIDTH = &H110
    DST_HEIGHT = &H114
    DST_HEIGHT_WIDTH = &H118
    DST_BRES_LNTH = &H120
    DST_BRES_ERR = &H124
    LEAD_BRES_ERR = &H124
    DST_BRES_INC = &H128
    LEAD_BRES_INC = &H128
    DST_BRES_DEC = &H12C
    LEAD_BRES_DEC = &H12C
    DST_CNTL = &H130

    TRAIL_BRES_ERR = &H138
    TRAIL_BRES_INC = &H13C
    TRAIL_BRES_DEC = &H140
    LEAD_BRES_LNTH = &H144

    SRC_OFF_PITCH = &H180
    SRC_X = &H184
    SRC_Y = &H188
    SRC_Y_X = &H18C
    SRC_WIDTH1 = &H190
    SRC_HEIGHT1 = &H194
    SRC_HEIGHT1_WIDTH1 = &H198
    SRC_X_START = &H019C
    SRC_Y_START = &H01A0
    SRC_Y_X_START = &H01A4
    SRC_HEIGHT2_WIDTH2 = &H1B0
    SRC_CNTL = &H1B4

    HOST_CNTL = &H240

    PAT_REG0 = &H280
    PAT_REG1 = &H284
    PAT_CNTL = &H288

    SC_LEFT = &H2A0
    SC_RIGHT = &H2A4
    SC_LEFT_RIGHT = &H2A8
    SC_TOP = &H2AC
    SC_BOTTOM = &H2B0
    SC_TOP_BOTTOM = &H02B4

    DP_BKGD_CLR = &H2C0
    DP_FRGD_CLR = &H2C4
    DP_WRITE_MASK = &H2C8
    DP_CHAIN_MASK = &H2CC
    DP_PIX_WIDTH = &H2D0
    DP_MIX = &H2D4
    DP_SRC = &H2D8

  ' FIFO

    FIFO_STAT = &H310

  ' more

    CONTEXT_MASK = &H320
    
  ' vertex

    VERTEX_1_S = &H0640
    VERTEX_1_T = &H0644
    VERTEX_1_W = &H0648
    VERTEX_1_SPEC_ARGB = &H064c
    VERTEX_1_Z = &H0650
    VERTEX_1_ARGB = &H0654
    VERTEX_1_X_Y = &H0658
    VERTEX_2_S = &H0660
    VERTEX_2_T = &H0664
    VERTEX_2_W = &H0668
    VERTEX_2_SPEC_ARGB = &H066c
    VERTEX_2_Z = &H0670
    VERTEX_2_ARGB = &H0674
    VERTEX_2_X_Y = &H0678
    VERTEX_3_S = &H0680
    VERTEX_3_T = &H0684
    VERTEX_3_W = &H0688
    VERTEX_3_SPEC_ARGB = &H068c
    VERTEX_3_Z = &H0690
    VERTEX_3_ARGB = &H0694
    VERTEX_3_X_Y = &H0698

    ONE_OVER_AREA_UC = &H0700

End Enum

' Enumeration: Mach64_crtc_gen_cntl
' Lists the fields in the <Mach64_regs.CRTC_GEN_CNTL> register
Enum Mach64_crtc_gen_cntl
    CRTC_DBLSCAN_EN    = &H00000001
    CRTC_INTERLACE_EN  = &H00000002
    CRTC_HSYNC_DIS     = &H00000004
    CRTC_VSYNC_DIS     = &H00000008
    CRTC_CSYNC_EN      = &H00000010
    CRTC_2PIX_EN       = &H00000020
    CRTC_BITDEPTH_MASK = &H00000700
    CRTC_BPP_4              = &H100
    CRTC_BPP_8              = &H200
    CRTC_BPP_15             = &H300
    CRTC_BPP_16             = &H400
    CRTC_BPP_24             = &H500
    CRTC_BPP_32             = &H600
    CRTC_BYTE_PIX_ORDER= &H00000800
    CRTC_FIFO_LWM_MASK = &H000F0000
    ' Constant: CRTC_EXT_DISP_EN
    ' allows the programmer to switch between the VGA and native CRTC
    '
    ' set to enable the accelerated CRTC
    CRTC_EXT_DISP_EN   = &H01000000
    ' Constant: CRTC_EN
    ' enables the CRTC when set, resets the CRTC when clear.
    CRTC_EN            = &H02000000
    CRTC_VGA_LINEAR    = &H08000000
    CRTC_CNT_EN        = &H40000000
End Enum

' Enumeration: Mach64_clock_regs
' Lists the registers of the integrated clock
'
' the register is to be shifted left by 2 then filled in <Mach64_regs.CLOCK_CNTL_ADDR>
Enum Mach64_clock_regs
    PLL_REF_DIV = &H02

    ' pll gen ctl fields = OSC_EN + DLL_PWDN + &H40 for sclk + &H30 for postdivider
    PLL_GEN_CNTL = &H03

    MCLK_FB_DIV = &H04
    PLL_VCLK_CNTL = &H05

    ' postdividers for each pixel clock (4x 2 bits packed in one reg)
    ' clock 0: 03, clock 1: 0c, clock 2: 30, clock 3: c0
    VCLK_POST_DIV = &H06

    ' FB div for each pixel clock
    VCLK0_FB_DIV = &H07
    VCLK1_FB_DIV = &H08
    VCLK2_FB_DIV = &H09
    VCLK3_FB_DIV = &H0A

    ' pll ext fields = PLL_MFB_TIMES_4_2B + &H07 clock selection
    ' same reg, different name according to Xorg. Extended postdivider in bits 4-7 (for clocks 0..3)
    ' bits 0..2 = clock selection (for xclk?)
    ' bit 3
    PLL_EXT_CNTL = &H0B
    PLL_XCLK_CNTL = &H0B

        'PLL_EXT_CNTL_XCLK_POSTDIV = &H07
        
    ' has to do with the DSP. Mostly magic. 
    ' bit 6 = reset?
    DLL_CNTL = &H0C
    
    ' more magic
    VFC_CNTL = &H0D

End Enum

' Enumeration: Mach64_gen_test_cntl
' Lists the fields of the <Mach64_regs.GEN_TEST_CNTL> register
Enum Mach64_gen_test_cntl
    GEN_EE_DATA_OUT      = &H00000001
    GEN_EE_CLOCK         = &H00000002
    GEN_EE_CHIP_SEL      = &H00000004
    GEN_EE_DATA_IN       = &H00000008
    GEN_EE_EN            = &H00000010
    GEN_OVR_OUTPUT_EN    = &H00000020
    GEN_OVR_POLARITY     = &H00000040
    GEN_CUR_EN           = &H00000080
    GEN_GUI_EN           = &H00000100
    GEN_BLOCK_WR_EN      = &H00000200
    GEN_TEST_FIFO_EN     = &H00010000
    GEN_TEST_GUI_REGS_EN = &H00020000
    GEN_TEST_VECT_EN     = &H00040000
    GEN_TEST_SRC_STR     = &H00080000
    ' more GEN_TEST_***
End Enum

' Enumeration: Mach64_bus_cntl
' Lists the fields of the <Mach64_regs.BUS_CNTL> register
Enum Mach64_bus_cntl

    ' Magic bit? (vgadoc disagrees on its meaning - used to allow access to MMIO register space)
    BUS_APER_REG_DIS = &H00000010

    BUS_FIFO_ERR_ACK = &H00200000
    BUS_HOST_ERR_ACK = &H00800000
End Enum
