/* Summary: glbuffer.h
 * Defines an interface for output maps
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
#ifndef _GL_INTERNAL_GLBUFFER_H_
#define _GL_INTERNAL_GLBUFFER_H_

#include <GL/gl_types.h>

typedef struct GLbuffer
{
    GLubyte * base;
    GLuint width;
    GLuint height;
    GLuint pitch;
    GLuint stride;
    
    void (*fillbuffer)(GLint, GLint, GLsizei, GLsizei, GLubyte, GLubyte, GLubyte, GLubyte, struct GLbuffer *);
    void (*writebuffer)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, struct GLbuffer *);
} GLbuffer;

extern GLbuffer * _gl_framebuffer;
extern GLbuffer * _gl_backbuffer;
extern GLbuffer * _gl_currentbuffer;

extern GLubyte _gl_clear_r, _gl_clear_g, _gl_clear_b, _gl_clear_a;

extern GLint _gl_cutoff_n, _gl_cutoff_e, _gl_cutoff_s, _gl_cutoff_w;
extern GLint _gl_scissor_n, _gl_scissor_e, _gl_scissor_s, _gl_scissor_w;
extern GLubyte _gl_scissor_en;

void _gl_setoutput(GLubyte * buffer, GLuint w, GLuint h, GLuint pitch);

void _gl_fillbuffer_b8g8r8a8(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest);
void _gl_fillbuffer_r8g8b8a8(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest);
void _gl_fillbuffer_b8g8r8(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest);
void _gl_fillbuffer_r8g8b8(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest);
void _gl_fillbuffer_r5g6b5(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest);
void _gl_fillbuffer_b5g6r5(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest);
void _gl_fillbuffer_b5g5r5(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest);
void _gl_fillbuffer_i8(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLbuffer * dest);
void _gl_writebuffer_r8g8b8x8(GLint x, GLint y, GLsizei w, GLsizei h, GLenum format, GLenum type, const GLvoid * pixels, GLbuffer * dest);
void _gl_writebuffer_b8g8r8x8(GLint x, GLint y, GLsizei w, GLsizei h, GLenum format, GLenum type, const GLvoid * pixels, GLbuffer * dest);
void _gl_writebuffer_b8g8r8(GLint x, GLint y, GLsizei w, GLsizei h, GLenum format, GLenum type, const GLvoid * pixels, GLbuffer * dest);
void _gl_writebuffer_r8g8b8(GLint x, GLint y, GLsizei w, GLsizei h, GLenum format, GLenum type, const GLvoid * pixels, GLbuffer * dest);
void _gl_writebuffer_r5g6b5(GLint x, GLint y, GLsizei w, GLsizei h, GLenum format, GLenum type, const GLvoid * pixels, GLbuffer * dest);
void _gl_writebuffer_b5g6r5(GLint x, GLint y, GLsizei w, GLsizei h, GLenum format, GLenum type, const GLvoid * pixels, GLbuffer * dest);
void _gl_writebuffer_b5g5r5(GLint x, GLint y, GLsizei w, GLsizei h, GLenum format, GLenum type, const GLvoid * pixels, GLbuffer * dest);
void _gl_writebuffer_i8(GLint x, GLint y, GLsizei w, GLsizei h, GLenum format, GLenum type, const GLvoid * pixels, GLbuffer * dest);

#endif
