/* Summary: glmatrix.h
 * Defines an interface for the matrices
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl_types.h>

typedef struct GLmatrix
{
    GLfloat m[16];
} GLmatrix;

extern GLmatrix _gl_currentmatrix;
extern GLmatrix _gl_viewportmatrix;
extern GLint _gl_viewoffx, _gl_viewoffy;
extern GLint _gl_matrixvalid;

extern GLmatrix _gl_modelview_stack[32];
extern GLmatrix _gl_projection_stack[32];
extern GLmatrix _gl_texture_stack[32];
extern GLint _gl_modelview_top;
extern GLint _gl_projection_top;
extern GLint _gl_texture_top;

extern GLmatrix * _gl_selectedmatrix;
extern GLint _gl_selectedstack_top;
extern GLint _gl_selectedstack;

void _gl_reloadmatrix(void);
void _gl_matrixmultiply(GLmatrix *, GLmatrix *);
