/* Summary: glpipe.h
 * Defines an interface to the rendering pipe
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
#ifndef _GL_INTERNAL_GLPIPE_H_
#define _GL_INTERNAL_GLPIPE_H_

#include "glvertex.h"

extern GLvertex _gl_pipe_vtx[4];
extern GLenum _gl_rendermode;
extern GLenum _gl_vertindex;

extern GLubyte _gl_vc_r, _gl_vc_g, _gl_vc_b, _gl_vc_a;
extern GLfloat _gl_vt_u, _gl_vt_v, _gl_vt_w, _gl_vt_h;

extern void (*_gl_rendertri)(GLvertex *, GLvertex*, GLvertex*);
extern void (*_gl_rendertriflat)(GLvertex *, GLvertex*, GLvertex*);
extern void (*_gl_rendertricol)(GLvertex *, GLvertex*, GLvertex*);

extern void (*_gl_renderblit)(GLint, GLint, GLint, GLint, GLint, GLint);
extern void (*_gl_renderblitalpha)(GLint, GLint, GLint, GLint, GLint, GLint);

void _gl_flattriangle32(GLvertex *, GLvertex *, GLvertex *);
void _gl_goraudtriangle32(GLvertex *, GLvertex *, GLvertex *);
void _gl_textriangle32(GLvertex *, GLvertex *, GLvertex *);

void _gl_bitblt32(GLint, GLint, GLint, GLint, GLint, GLint);

extern GLint _gl_cull_sign, _gl_cull_enable, _gl_cull_front;

#endif
