/* Summary: gltexture.h
 * Defines an interface for textures
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
#ifndef _GL_INTERNAL_GLTEXTURE_H_
#define _GL_INTERNAL_GLTEXTURE_H_
#include "glbuffer.h"

typedef struct GLtexture
{
    GLbuffer texture;

    GLint ubits;
    GLint vbits;
    GLint border;

} GLtexture;

extern GLtexture * _gl_currenttexture;

void _gl_deletetexture(GLtexture *);
void _gl_inittextures(void);
void _gl_shutdowntextures(void);

extern void (*_gl_writebuffer)(GLint, GLint, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, GLbuffer * dest);
extern void (*_gl_fillbuffer)(GLint, GLint, GLsizei, GLsizei, GLubyte, GLubyte, GLubyte, GLubyte, GLbuffer *);

#endif
