'
' Summary: udi.bi
' contains the Freebasic version of <udi.h>
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'
#ifndef _UDI_BI_
#define _UDI_BI_

type udi_cb_t
    channel As Integer ' udi_channel_t = intptr
    context As Byte Ptr
    scratch As Byte Ptr
    initiator_context As Byte Ptr
    origin As Integer 'udi_origin_t = intptr
End Type

Type udi_ops_init_t
    ops_idx As Unsigned Integer
    meta_idx As Unsigned Integer
    meta_ops_num As Unsigned Integer
    chan_context_size As Unsigned Integer
    ops_vector As Byte Ptr 'udi_ops_vector_t *
    op_flags As Byte Ptr 'const udi_ubit8_t *
End Type

Type udi_init_t
    primary_init_info As Byte Ptr 'udi_primary_init_t *
    secondary_init_list As Byte Ptr 'udi_secondary_init_t *
    ops_init_list As udi_ops_init_t Ptr
    cb_init_list As Byte Ptr 'udi_cb_init_t *
    gcb_init_list As Byte Ptr 'udi_gcb_init_t *
    cb_select_list As Byte Ptr 'udi_cb_select_t *
End Type

Extern udi_init_info Alias "udi_init_info" As udi_init_t

Const UDI_OK = 0
Const UDI_STAT_NOT_SUPPORTED = 1
Const UDI_STAT_NOT_UNDERSTOOD = 2
Const UDI_STAT_INVALID_STATE = 3
Const UDI_STAT_MISTAKEN_IDENTITY = 4
Const UDI_STAT_ABORTED = 5
Const UDI_STAT_TIMEOUT = 6
Const UDI_STAT_BUSY = 7
Const UDI_STAT_RESOURCE_UNAVAIL = 8
Const UDI_STAT_HW_PROBLEM = 9
Const UDI_STAT_NOT_RESPONDING = 10
Const UDI_STAT_DATA_UNDERRUN = 11
Const UDI_STAT_DATA_OVERRUN = 12
Const UDI_STAT_DATA_ERROR = 13
Const UDI_STAT_PARENT_DRV_ERROR = 14
Const UDI_STAT_CANNOT_BIND = 15
Const UDI_STAT_CANNOT_BIND_EXCL = 16
Const UDI_STAT_TOO_MANY_PARENTS = 17
Const UDI_STAT_BAD_PARENT_TYPE = 18
Const UDI_STAT_TERMINATED = 19
Const UDI_STAT_ATTR_MISMATCH = 20


#endif
