/**
 * Summary: udi_nic.h
 * Contains the network driver metalanguage interface details
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#ifndef __UDI_NIC_H__
#define __UDI_NIC_H__

#include <udi.h>

// 2.1
#ifndef UDI_NIC_VERSION
#error "UDI_NIC_VERSION not defined."
#elif UDI_NIC_VERSION != 0x101
#error "UDI_NIC_VERSION not supported."
#endif

// 2.2

// Enumeration: UDI_NIC_MEDIATYPE
// String defines for the specified interface media types
#define UDI_NIC_ETHER_TEXT      "eth"
#define UDI_NIC_TOKEN_TEXT      "tr"
#define UDI_NIC_FASTETHER_TEXT  "fe"
#define UDI_NIC_GIGETHER_TEXT   "ge"
#define UDI_NIC_VGANYLAN_TEXT   "vg"
#define UDI_NIC_FDDI_TEXT       "fddi"
#define UDI_NIC_ATM_TEXT        "atm"
#define UDI_NIC_FC_TEXT         "fc"
#define UDI_NIC_MISCMEDIA_TEXT  "net"

// todo: rest of 2 (if there's anything)?

// todo: 3.1, 3.2, 3.3.1, 3-17 - 3-31

// 3.3.2 3-22
typedef struct {
    udi_cb_t gcb;
} udi_nic_cb_t;
/* Network Standard Control Block Group Number */
#define UDI_NIC_STD_CB_NUM 1

// 3.3.2 3-23 - 3-27

/* Maximum MAC Address Size Definition */
#define UDI_NIC_MAC_ADDRESS_SIZE 20

typedef struct {
    udi_cb_t gcb;
    udi_ubit8_t media_type;
    udi_ubit32_t min_pdu_size;
    udi_ubit32_t max_pdu_size;
    udi_ubit32_t rx_hw_threshold;
    udi_ubit32_t capabilities;
    udi_ubit8_t max_perfect_multicast;
    udi_ubit8_t max_total_multicast;
    udi_ubit8_t mac_addr_len;
    udi_ubit8_t mac_addr [UDI_NIC_MAC_ADDRESS_SIZE];
} udi_nic_bind_cb_t;
/* Network Bind Control Block Group Number */
#define UDI_NIC_BIND_CB_NUM 2
/* media_type values */
#define UDI_NIC_ETHER           0
#define UDI_NIC_TOKEN           1
#define UDI_NIC_FASTETHER       2
#define UDI_NIC_GIGETHER        3
#define UDI_NIC_VGANYLAN        4
#define UDI_NIC_FDDI            5
#define UDI_NIC_ATM             6
#define UDI_NIC_FC              7
#define UDI_NIC_MISCMEDIA       0xff
/* capabilities indications */
#define UDI_NIC_CAP_TX_IP_CKSUM     (1U << 0)
#define UDI_NIC_CAP_TX_TCP_CKSUM    (1U << 1)
#define UDI_NIC_CAP_TX_UDP_CKSUM    (1U << 2)
#define UDI_NIC_CAP_MCAST_LOOPBK    (1U << 3)
#define UDI_NIC_CAP_BCAST_LOOPBK    (1U << 4)
/* capabilities requests */
#define UDI_NIC_CAP_USE_TX_CKSUM    (1U << 30)
#define UDI_NIC_CAP_USE_RX_CKSUM    (1U << 31)

// 3.3.6 3-37 - 3.42
typedef struct {
    udi_cb_t gcb;
    udi_ubit8_t command;
    udi_ubit32_t indicator;
    udi_buf_t *data_buf;
} udi_nic_ctrl_cb_t;
/* Network Control Op Control Block Group Num */
#define UDI_NIC_CTRL_CB_NUM 3
/* Network Control Operation Commands */
#define UDI_NIC_ADD_MULTI       1
#define UDI_NIC_DEL_MULTI       2
#define UDI_NIC_ALLMULTI_ON     3
#define UDI_NIC_ALLMULTI_OFF    4
#define UDI_NIC_GET_CURR_MAC    5
#define UDI_NIC_SET_CURR_MAC    6
#define UDI_NIC_GET_FACT_MAC    7
#define UDI_NIC_PROMISC_ON      8
#define UDI_NIC_PROMISC_OFF     9
#define UDI_NIC_HW_RESET        10
#define UDI_NIC_BAD_RXPKT       11

// 3.3.6 3-45 - 3-46
typedef struct {
    udi_cb_t gcb;
    udi_ubit8_t event;
} udi_nic_status_cb_t;
/* Network Status Control Block Group Number */
#define UDI_NIC_STATUS_CB_NUM   4
/* Network Status Event Codes */
#define UDI_NIC_LINK_DOWN       0
#define UDI_NIC_LINK_UP         1
#define UDI_NIC_LINK_RESET      2

// 3.3.6 3-48 - 3-50
typedef struct {
    udi_cb_t gcb;
    udi_boolean_t interface_is_active;
    udi_boolean_t link_is_active;
    udi_boolean_t is_full_duplex;
    udi_ubit32_t link_mbps;
    udi_ubit32_t link_bps;
    udi_ubit32_t tx_packets;
    udi_ubit32_t rx_packets;
    udi_ubit32_t tx_errors;
    udi_ubit32_t rx_errors;
    udi_ubit32_t tx_discards;
    udi_ubit32_t rx_discards;
    udi_ubit32_t tx_underrun;
    udi_ubit32_t rx_overrun;
    udi_ubit32_t collisions;
} udi_nic_info_cb_t;
/* Network Information Control Block Group Number */
#define UDI_NIC_INFO_CB_NUM     5

// 3.4 3-54 3-55
typedef struct udi_nic_tx_cb_t {
    udi_cb_t gcb;
    struct udi_nic_tx_cb_t *chain;
    udi_buf_t *tx_buf;
    udi_boolean_t completion_urgent;
} udi_nic_tx_cb_t;
/* Network Transmit Control Block Group Number */
#define UDI_NIC_TX_CB_NUM       6

// 3.4 3-59 - 3-62
typedef struct udi_nic_rx_cb_t {
    udi_cb_t gcb;
    struct udi_nic_rx_cb_t *chain;
    udi_buf_t *rx_buf;
    udi_ubit8_t rx_status;
    udi_ubit8_t addr_match;
    udi_ubit8_t rx_valid;
} udi_nic_rx_cb_t;
/* Network Receive Control Block Group Number */
#define UDI_NIC_RX_CB_NUM       7
/* values for rx_status */
#define UDI_NIC_RX_BADCKSUM     (1U << 0)
#define UDI_NIC_RX_UNDERRUN     (1U << 1)
#define UDI_NIC_RX_OVERRUN      (1U << 2)
#define UDI_NIC_RX_DRIBBLE      (1U << 3)
#define UDI_NIC_RX_FRAME_ERR    (1U << 4)
#define UDI_NIC_RX_MAC_ERR      (1U << 5)
#define UDI_NIC_RX_OTHER_ERR    (1U << 7)
/* values for addr_match */
#define UDI_NIC_RX_UNKNOWN      0
#define UDI_NIC_RX_EXACT        1
#define UDI_NIC_RX_HASH         2
#define UDI_NIC_RX_BROADCAST    3
/* values for rx_valid */
#define UDI_NIC_RX_GOOD_IP_CKSUM  (1U << 0)
#define UDI_NIC_RX_GOOD_TCP_CKSUM (1U << 1)
#define UDI_NIC_RX_GOOD_UDP_CKSUM (1U << 2)



// 3.3.4 3-28
typedef void udi_nd_bind_req_op_t (udi_nic_bind_cb_t *cb, udi_index_t tx_chan_index, udi_index_t rx_chan_index);
udi_nd_bind_req_op_t udi_nd_bind_req;

// 3.3.4 3-29
typedef void udi_nsr_bind_ack_op_t (udi_nic_bind_cb_t *cb, udi_status_t status);
udi_nsr_bind_ack_op_t udi_nsr_bind_ack;

// 3.3.4 3-30
typedef void udi_nd_unbind_req_op_t (udi_nic_cb_t *cb);
udi_nd_unbind_req_op_t udi_nd_unbind_req;

// 3.3.4 3-31
typedef void udi_nsr_unbind_ack_op_t (udi_nic_cb_t *cb, udi_status_t status);
udi_nsr_unbind_ack_op_t udi_nsr_unbind_ack;

// 3.3.4 3-33
typedef void udi_nd_enable_req_op_t (udi_nic_cb_t *cb);
udi_nd_enable_req_op_t udi_nd_enable_req;

// 3.3.4 3-34
typedef void udi_nsr_enable_ack_op_t (udi_nic_cb_t *cb, udi_status_t status);
udi_nsr_enable_ack_op_t udi_nsr_enable_ack;

// 3.3.4 3-35
typedef void udi_nd_disable_req_op_t (udi_nic_cb_t *cb);
udi_nd_disable_req_op_t udi_nd_disable_req;

// 3.3.6 3-43
typedef void udi_nd_ctrl_req_op_t (udi_nic_ctrl_cb_t *cb);
udi_nd_ctrl_req_op_t udi_nd_ctrl_req;

// 3.3.6 3-44
typedef void udi_nsr_ctrl_ack_op_t (udi_nic_ctrl_cb_t *cb, udi_status_t status);
udi_nsr_ctrl_ack_op_t udi_nsr_ctrl_ack;

// 3.3.6 3-47
typedef void udi_nsr_status_ind_op_t (udi_nic_status_cb_t *cb);
udi_nsr_status_ind_op_t udi_nsr_status_ind;

// 3.3.6 3-51
typedef void udi_nd_info_req_op_t (udi_nic_info_cb_t *cb, udi_boolean_t reset_statistics);
udi_nd_info_req_op_t udi_nd_info_req;

// 3.3.6 3-52
typedef void udi_nsr_info_ack_op_t (udi_nic_info_cb_t *cb);
udi_nsr_info_ack_op_t udi_nsr_info_ack;

// 3.4 3-56
typedef void udi_nsr_tx_rdy_op_t (udi_nic_tx_cb_t *cb);
udi_nsr_tx_rdy_op_t udi_nsr_tx_rdy;

// 3.4 3-57
typedef void udi_nd_tx_req_op_t (udi_nic_tx_cb_t *cb);
udi_nd_tx_req_op_t udi_nd_tx_req;

// 3.4 3-58
typedef void udi_nd_exp_tx_req_op_t (udi_nic_tx_cb_t *cb);
udi_nd_exp_tx_req_op_t udi_nd_exp_tx_req;

// 3.4 3-63
typedef void udi_nsr_rx_ind_op_t (udi_nic_rx_cb_t *cb);
udi_nsr_rx_ind_op_t udi_nsr_rx_ind;

// 3.4 3-64
typedef void udi_nsr_exp_rx_ind_op_t (udi_nic_rx_cb_t *cb);
udi_nsr_exp_rx_ind_op_t udi_nsr_exp_rx_ind;

// 3.4 3-65
typedef void udi_nd_rx_rdy_op_t (udi_nic_rx_cb_t *cb);
udi_nd_rx_rdy_op_t udi_nd_rx_rdy;


// 3.3.2 3-10
typedef const struct 
{
    udi_channel_event_ind_op_t  *channel_event_ind_op;
    udi_nd_bind_req_op_t        *nd_bind_req_op;
    udi_nd_unbind_req_op_t      *nd_unbind_req_op;
    udi_nd_enable_req_op_t      *nd_enable_req_op;
    udi_nd_disable_req_op_t     *nd_disable_req_op;
    udi_nd_ctrl_req_op_t        *nd_ctrl_req_op;
    udi_nd_info_req_op_t        *nd_info_req_op;
} udi_nd_ctrl_ops_t;
#define UDI_ND_CTRL_OPS_NUM 1

// 3.3.2 3-12
typedef const struct {
    udi_channel_event_ind_op_t  *channel_event_ind_op;
    udi_nd_tx_req_op_t          *nd_tx_req_op;
    udi_nd_exp_tx_req_op_t      *nd_exp_tx_req_op;
} udi_nd_tx_ops_t;
/* ND TX Ops Vector Number */
#define UDI_ND_TX_OPS_NUM 2

// 3.3.2 3-13
typedef const struct {
    udi_channel_event_ind_op_t  *channel_event_ind_op;
    udi_nd_rx_rdy_op_t          *nd_rx_rdy_op;
} udi_nd_rx_ops_t;
/* ND Receive Ops Vector Number */
#define UDI_ND_RX_OPS_NUM 3

// 3.3.2 3-14
typedef const struct {
    udi_channel_event_ind_op_t  *channel_event_ind_op;
    udi_nsr_bind_ack_op_t       *nsr_bind_ack_op;
    udi_nsr_unbind_ack_op_t     *nsr_unbind_ack_op;
    udi_nsr_enable_ack_op_t     *nsr_enable_ack_op;
    udi_nsr_ctrl_ack_op_t       *nsr_ctrl_ack_op;
    udi_nsr_info_ack_op_t       *nsr_info_ack_op;
    udi_nsr_status_ind_op_t     *nsr_status_ind_op;
} udi_nsr_ctrl_ops_t;
/* NSR Control Ops Vector Number */
#define UDI_NSR_CTRL_OPS_NUM 4

// 3.3.2 3-15
typedef const struct {
    udi_channel_event_ind_op_t  *channel_event_ind_op;
    udi_nsr_tx_rdy_op_t         *nsr_tx_rdy_op;
} udi_nsr_tx_ops_t;
/* NSR Transmit Ops Vector Number */
#define UDI_NSR_TX_OPS_NUM 5

// 3.3.2 3-16
typedef const struct {
    udi_channel_event_ind_op_t  *channel_event_ind_op;
    udi_nsr_rx_ind_op_t         *nsr_rx_ind_op;
    udi_nsr_exp_rx_ind_op_t     *nsr_exp_rx_ind_op;
} udi_nsr_rx_ops_t;
/* NSR Receive Ops Vector Number */
#define UDI_NSR_RX_OPS_NUM 6

#endif

