'
' Summary: x86emu.bi
' *Contains the freebasic definitions of x86emu*
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#ifndef X86EMU_BI
#define X86EMU_BI

Type I386_GENERAL_REGS
    A As Unsigned Integer
    B As Unsigned Integer
    C As Unsigned Integer
    D As Unsigned Integer
End Type

Type I386_SPECIAL_REGS
    SP As Unsigned Integer
    BP As Unsigned Integer
    SI As Unsigned Integer
    DI As Unsigned Integer
    IP As Unsigned Integer
    flags As Unsigned Integer
End Type

Type X86EMU_REGS
    gen As I386_GENERAL_REGS
    spc As I386_SPECIAL_REGS
End Type

Type X86EMU
    x86 As X86EMU_REGS
    Custom As Byte Ptr
End Type

Const INTR_TYPE_SOFT        As Byte = 1
Const INTR_TYPE_FAULT       As Byte = 2
Const INTR_MODE_RESTART     As Integer = &H100
Const INTR_MODE_ERRCODE     As Integer = &H200

Const X86EMU_RUN_TIMEOUT    As Byte = (1 SHL 0)
Const X86EMU_RUN_MAX_INSTR  As Byte = (1 SHL 1)
Const X86EMU_RUN_NO_EXEC    As Byte = (1 SHL 2)
Const X86EMU_RUN_NO_CODE    As Byte = (1 SHL 3)
Const X86EMU_RUN_LOOP       As Byte = (1 SHL 4)

Const X86EMU_MEMIO_8        As Integer = 0
Const X86EMU_MEMIO_16       As Integer = 1
Const X86EMU_MEMIO_32       As Integer = 2
Const X86EMU_MEMIO_8_NOPERM As Integer = 3
Const X86EMU_MEMIO_R        As Integer = (0 SHL 8)
Const X86EMU_MEMIO_W        As Integer = (1 SHL 8)
Const X86EMU_MEMIO_X        As Integer = (2 SHL 8)
Const X86EMU_MEMIO_I        As Integer = (3 SHL 8)
Const X86EMU_MEMIO_O        As Integer = (4 SHL 8)

Declare Function x86emu_new     CDecl alias "x86emu_new"    (ByVal def_mem_perm As Integer, ByVal def_io_perm As Integer) As X86EMU Ptr
Declare Function x86emu_done    CDecl alias "x86emu_done"   (ByVal emu as X86EMU Ptr) As X86EMU Ptr
Declare Function x86emu_clone   CDecl alias "x86emu_clone"  (ByVal emu as X86EMU Ptr) As X86EMU Ptr

Declare Sub      x86emu_reset   CDecl alias "x86emu_reset"  (ByVal emu As X86EMU Ptr)
Declare Function x86emu_run     CDecl alias "x86emu_run"    (ByVal emu As X86EMU Ptr, ByVal flags As Integer) As Integer
Declare Sub      x86emu_stop    CDecl alias "x86emu_stop"   (ByVal emu As X86EMU Ptr)

'void x86emu_set_log(x86emu_t *emu, unsigned buffer_size, x86emu_flush_func_t flush);
'unsigned x86emu_clear_log(x86emu_t *emu, int flush);
'void x86emu_log(x86emu_t *emu, const char *format, ...) __attribute__ ((format (printf, 2, 3)));
'void x86emu_dump(x86emu_t *emu, int flags);

'void x86emu_set_perm(x86emu_t *emu, unsigned start, unsigned end, unsigned perm);
'void x86emu_set_io_perm(x86emu_t *emu, unsigned start, unsigned end, unsigned perm);
'void x86emu_set_page(x86emu_t *emu, unsigned page, void *address);
'void x86emu_reset_access_stats(x86emu_t *emu);


Declare Function x86vm_inb      CDecl Alias "x86vm_inb"     (ByVal addr As Unsigned Short) As Unsigned Byte
Declare Function x86vm_inw      CDecl Alias "x86vm_inw"     (ByVal addr As Unsigned Short) As Unsigned Short
Declare Function x86vm_inl      CDecl Alias "x86vm_inl"     (ByVal addr As Unsigned Short) As Unsigned Integer

Declare Sub      x86vm_outb     CDecl Alias "x86vm_outb"    (ByVal value As Unsigned Byte, ByVal addr As Unsigned Short)
Declare Sub      x86vm_outw     CDecl Alias "x86vm_outw"    (ByVal value As Unsigned Short, ByVal addr As Unsigned Short)
Declare Sub      x86vm_outl     CDecl Alias "x86vm_outl"    (ByVal value As Unsigned Integer, ByVal addr As Unsigned Short)

#endif 
