/* Summary: x86emu_vm.h
 * 
 * Defines the functions to be implemented by the host program
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#ifndef _X86EMU_VM_H_
#define _X86EMU_VM_H_

#include <stdint.h>

uint8_t  x86vm_inb(uint16_t addr);
uint16_t x86vm_inw(uint16_t addr);
uint32_t x86vm_inl(uint16_t addr);

void x86vm_outb(uint8_t  val, uint16_t addr);
void x86vm_outw(uint16_t val, uint16_t addr);
void x86vm_outl(uint32_t val, uint16_t addr);
void x86vm_memlog(uint32_t addr, uint32_t err);

#endif

