;
; Summary: inc_syscall.asm
; *Listing of kernel functions available in userspace*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Educational Purposes
;

_kernel_KernelVersion       EQU 0x00000000
_kernel_BlockAlloc          EQU 0x00000001
_kernel_BlockAllocEx        EQU 0x00000002
_kernel_BlockAllocPhys      EQU 0x00000003
_kernel_EnterV8086          EQU 0x00000004
_kernel_AllocateIoBitmap    EQU 0x00000005
_kernel_PortAlloc           EQU 0x00000006
_kernel_AllocatePageTable   EQU 0x00000007
_kernel_BlockAllocExL       EQU 0x00000008
_kernel_BlockAllocPhysL     EQU 0x00000009
_kernel_AllocateIRBitmap    EQU 0x0000000A
_kernel_SetRedirectBits     EQU 0x0000000B
_kernel_ManageMemoryL1      EQU 0x0000000C
_kernel_ManageMemoryL2      EQU 0x0000000D
_kernel_Yield               EQU 0x0000000E
_kernel_CreateAddressSpace  EQU 0x0000000F
_kernel_CreateThread        EQU 0x00000010
_kernel_CreateThreadRemote  EQU 0x00000011
_kernel_TransferPage        EQU 0x00000012
_kernel_AllocatePageTableRemote EQU 0x00000013
_kernel_BlockDealloc        EQU 0x00000014
_kernel_Yank                EQU 0x00000015

; Macro: kernel
; expands to the system call given as parameter
%macro kernel 1
       MOV EAX, _kernel_%1
       INT 0x81
%endmacro
