' Summary: mos.bi
' The FreeBasic include for the MOS kernel interface
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'
' Defines:
'     <kernelversion> <blockalloc>  <blockallocex>
'     <blockallocphys> <blockdealloc> <enterv8086>  
'     <allocateiobitmap>
'     <portalloc> <allocatepagetable> <blockallocexl>
'     <blockallocphysl> <allocateirbitmap> <setredirectbits>
'     <managememoryl1> <managememoryl2> <yield> <yank>
'
' Linker Parameters:
'     -lmos
'

Type mos_v8086data
    ip As Unsigned Short
    cs As Unsigned Short
    flags As Unsigned Integer
    out_port As Unsigned Integer
    out_stack As Unsigned Byte Ptr
end type

Declare Function allocateiobitmap Cdecl Alias "allocateiobitmap" (ByVal base As Long, ByVal ports As Long, ByVal phys As Byte Ptr) As Long
Declare Function allocateirbitmap Cdecl Alias "allocateirbitmap" (ByVal phys As Byte Ptr) As Long
Declare Function allocatepagetable Cdecl Alias "allocatepagetable" (ByVal target As Byte Ptr, ByVal source As Byte Ptr) As Long
Declare Function blockalloc Cdecl Alias "blockalloc" (ByVal size As Long, ByVal base As Byte Ptr) As Long
Declare Function blockallocex Cdecl Alias "blockallocex" (ByVal size As Long, ByVal base As Byte Ptr, ByVal phys As Byte Ptr) As Long
Declare Function blockallocphys Cdecl Alias "blockallocphys" (ByVal size As Long, ByVal base As Byte Ptr, ByVal phys As Byte Ptr) As Long
Declare Function blockallocphysl Cdecl Alias "blockallocphysl" (ByVal size As Long, ByVal base As Byte Ptr, ByVal phys As Byte Ptr) As Long
Declare Function blockdealloc Cdecl Alias "blockdealloc" (ByVal bottom As Byte Ptr, ByVal top As Byte Ptr) As Byte Ptr
Declare Function createthreadremote Cdecl Alias "createthreadremote" (ByVal startaddress As Long, ByVal startstack As Byte Ptr, ByVal phys As Byte Ptr, ByVal dest As Byte Ptr, ByVal space As Long) As Long
Declare Function kernelversion Cdecl Alias "kernelversion" () as Long
Declare Function managememoryl1 Cdecl Alias "managememoryl1" (ByVal memory As Byte Ptr, ByVal address As Byte Ptr) As Long
Declare Function managememoryl2 Cdecl Alias "managememoryl2" (ByVal memory As Byte Ptr, ByVal address As Byte Ptr) As Long
Declare Function portalloc Cdecl Alias "portalloc" (ByVal base As Long, ByVal ports As Long) As Long
Declare Function setredirectbits Cdecl Alias "setredirectbits" (ByVal base As Long, ByVal ports As Long, ByVal status As Long) As Long
Declare Function transferpage Cdecl Alias "transferpage" (ByVal sourceaddress As Byte Ptr, ByVal destaddress As Byte Ptr, ByVal destspace As Long) As Long

Declare Sub enterv8086 Cdecl Alias "enterv8086" (ByVal descriptor As mos_v8086data Ptr)
Declare Sub yield Cdecl Alias "yield" ()
Declare Sub yank Cdecl Alias "yank" (ByVal option As Integer)

