/*
        Summary: mos.h
        *The header file for kernel interface library*

        Author:
            Marcel Sondaar

        License:
            Educational Purposes

        Defines:
            <kernelversion> <blockalloc>  <blockallocex>
            <blockallocphys> <enterv8086>  <allocateiobitmap>
            <portalloc> <allocatepagetable> <blockallocexl>
            <blockallocphysl> <allocateirbitmap> <setredirectbits>
            <managememoryl1> <managememoryl2> <yield> <yank>

        Linker Parameters:
            -lmos
*/

#ifndef _MOS_H_
#define _MOS_H_

typedef struct mos_v8086data
{
    unsigned short ip;
    unsigned short cs;
    unsigned int flags;
    int out_port;
    void * out_stack;
} mos_v8086data;

#ifdef __CPLUSPLUS__
extern "C" {
#endif

    int allocateiobitmap(int size, int ports, void * phys);
    int allocatepagetable(void * target, void * src);
    int blockalloc(int size, void * base);
    int blockallocex(int size, void * base, void * phys);
    int blockallocphys(int size, void * base, void * phys);
    int blockallocphysl(int size, void * base, void * phys);
    int blockdealloc(void * bottom, void * top);
    int kernelversion(void);
    int portalloc(int base, int ports);

    void enterv8086(mos_v8086data * descriptor);
    void yield(void);
    void yank(int value);

#ifdef __CPLUSPLUS__
}
#endif


#endif
