' Summary: atabus.bi
' Contains the message interface for AT attachments
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

Const ATABUSCOMMANDBASE = &H70000

' Enumeration: ATABUSCOMMANDS
' Lists the commands supported by general purpose register based drivers
Enum ATABUSCOMMANDS
    ' command packet
    ' byte 0-3: message id
    ' byte 4-7: device id
    ' byte 8: answer id
    ' byte 9: data direction
    ' then the programming sequences:
    '   byte 0-1: bitfield of registers to write
    '   byte 2-n: register values to write
    ' repeat
    ATABUSCOMMAND_CMD = ATABUSCOMMANDBASE + 0
    
    ' command packet
    ' byte 0-3 message id
    ' byte 4-7 device id
    ' byte 8-.. packet data
    ATABUSCOMMAND_PACKET = ATABUSCOMMANDBASE + 1
    ATABUSCOMMAND_STATUS = ATABUSCOMMANDBASE + 2
    ATABUSCOMMAND_DATA = ATABUSCOMMANDBASE + 3
End Enum
