' Summary: devmgr.bi
' Contains the message definitions for the device management server
'
' Author:
'     Marcel Sondaar
'
' License
'     <Public Domain>
'

' Constant: DEVMGRCOMMAND_BASE
' Base message id for device management commands
Const DEVMGRCOMMAND_BASE = &H00000000

' Enumeration: DEVMGRCOMMANDS
' Lists the messages that the device manager supports
Enum DEVMGRCOMMANDS

    ' Constant: DEVMGRCOMMANDS_CONNECTIVITY
    ' _Deprecated_ Requests the server to list the connected device IDs
    '
    ' format: 
    '     (4) <DEVMGRCOMMANDS_CONNECTIVITY>
    '     (4) Device ID     
    '    
    ' reply:
    '     (4) number of connected nodes
    '     (4x) array of connected Device IDs. The parent is always listed first.
    DEVMGRCOMMANDS_CONNECTIVITY = DEVMGRCOMMAND_BASE + 1  ' Browse node connectivity
        
    ' Constant: DEVMGRCOMMANDS_GETNAME
    ' Retrieves a node's name
    '     
    ' format:
    '     (4) <DEVMGRCOMMANDS_GETNAME>
    '     (4) The Device ID to which this node becomes a child
    '
    ' reply:
    '     (n) The byte string containing the name
    DEVMGRCOMMANDS_GETNAME      = DEVMGRCOMMAND_BASE + 2  ' Get node name
    
    ' Constant: DEVMGRCOMMANDS_ADD
    ' Requests a new DeviceID to be registerd
    '
    ' format:
    '     (4) <DEVMGRCOMMANDS_ADD>
    '     (4) The Device ID to which this node becomes a child
    '
    ' reply:
    '     (4) The newly generated Device ID    
    DEVMGRCOMMANDS_ADD          = DEVMGRCOMMAND_BASE + 4  ' Add node
    
    ' Constant: DEVMGRCOMMANDS_SETNAME
    ' Names a device
    '
    ' format:
    '     (4) <DEVMGRCOMMANDS_SETNAME>
    '     (4) Device ID     
    '     (x) A byte array containing the device name
    '
    ' reply:
    '     none
    DEVMGRCOMMANDS_SETNAME     = DEVMGRCOMMAND_BASE + 5  ' Set node name
    
    ' Constant: DEVMGRCOMMANDS_SETADDR
    ' Sets the message address for a device. 
    ' The address is not present in the message itself, instead the address used 
    ' to send this message will be taken as the third argument
    '
    ' format:
    '     (4) <DEVMGRCOMMANDS_SETINFO>
    '     (4) Device ID
    '
    ' reply:
    '     none
    DEVMGRCOMMANDS_SETADDR      = DEVMGRCOMMAND_BASE + 7  ' Set driver address
    
    ' Constant: DEVMGRCOMMANDS_GETADDR
    ' Retrieves a device's address
    '     
    ' format:
    '     (4) <DEVMGRCOMMANDS_GETADDR>
    '     (4) The Device ID for which to fetch the location
    '
    ' reply:
    '     (4) The device's currently registered address, or zero if not set (no driver active).
    DEVMGRCOMMANDS_GETADDR      = DEVMGRCOMMAND_BASE + 8  ' Get driver address
    
    ' Constant: DEVMGRCOMMANDS_SETLOCATION
    ' Names a device
    '
    ' format:
    '     (4) <DEVMGRCOMMANDS_SETINFO>
    '     (4) Device ID     
    '     (x) A byte array containing the device name
    '
    ' reply:
    '     none
    DEVMGRCOMMANDS_SETLOCATION  = DEVMGRCOMMAND_BASE + 9  ' Set driver address
    
    ' Constant: DEVMGRCOMMANDS_GETLOCATION
    ' Retrieves a node's location string
    '     
    ' format:
    '     (4) <DEVMGRCOMMANDS_GETLOCATION>
    '     (4) The Device ID for which to fetch the location
    '
    ' reply:
    '     (n) The byte array containing the location
    DEVMGRCOMMANDS_GETLOCATION  = DEVMGRCOMMAND_BASE + 10 ' Set driver address
    
    
    
    
    ' format: 
    '     (4) <DEVMGRCOMMANDS_CONNECTIVITY_REQ>
    '     (4) Device ID     
    '    
    ' reply:
    '     (4) <DEVMGRCOMMANDS_CONNECTIVITY_ACK>
    '     (4) Device ID
    '     (4) number of connected nodes
    '     (4x) array of connected Device IDs. The parent is always listed first.
    DEVMGRCOMMANDS_CONNECTIVITY_REQ = DEVMGRCOMMAND_BASE + 11  ' Browse node connectivity
    DEVMGRCOMMANDS_CONNECTIVITY_ACK = DEVMGRCOMMAND_BASE + 12  ' Return node connectivity
End Enum
