' Summary: driver.bi
' Contains the common interface for drivers
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

Declare Function DriverInit() As Integer

Declare Function mos_finddev CDecl Alias "mos_finddev" (ByVal Interface As Integer) As Integer

' Constant: SYSCOMMAND_QUERYINTERFACES
' The message identifier for getting a link's supported interfaces
Const SYSCOMMAND_QUERYINTERFACES = &H10000


' Enumeration: DRIVERINTERFACES
' Lists numbers for all basic driver interfaces
'
' This is used as an argument to the QueryInterface message
' where it is used to determine if the recipent supports the
' interface in question.
Enum DRIVERINTERFACES
    ' Constant: INTERFACE_SYSCOMMAND
    ' The base message code for system administration commands.
    INTERFACE_SYSCOMMAND = &H10000

    INTERFACE_HID        = &H20000

    ' Constant: INTERFACE_GRAPHICS
    ' Identifies the <GFXCOMMANDS> set
    INTERFACE_GRAPHICS   = &H30000
    INTERFACE_GRAPHICS2  = &H30004
    
    INTERFACE_BRIDGE     = &H40000
    
    ' Constant: INTERFACE_BLOCK
    ' Identifies the <BLOCKCOMMANDS> set
    INTERFACE_BLOCK      = &H50000

    INTERFACE_SCSI       = &H60000
    
    ' Constant INTERFACE_ATABUS
    ' Identifies the <ATABUSCOMMANDS> set
    INTERFACE_ATABUS     = &H70000

    ' Constant INTERFACE_FILE
    ' Identifies the <FILECOMMANDS> set
    INTERFACE_FILE       = &H80000
    INTERFACE_FILESEGMENT= &H80001
    INTERFACE_FILENAME   = &H80002

End Enum
