/* Summary: driver.h
 * Contains the common interface for drivers
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     Public Domain
 */

int DRIVERINIT(void);
#define DriverInit DRIVERINIT

int mos_finddev (int interface);


// Enumeration: DRIVERINTERFACES
// Lists numbers for all basic driver interfaces
//
// This is used as an argument to the QueryInterface message
// where it is used to determine if the recipent supports the
// interface in question.
    
    // Constant: INTERFACE_SYSCOMMAND
    // The base message code for system administration commands.
    #define INTERFACE_SYSCOMMAND     0x00010000

    #define INTERFACE_HID            0x00020000

    // Constant: INTERFACE_GRAPHICS
    // Identifies the <GFXCOMMANDS> set
    #define INTERFACE_GRAPHICS       0x00030000
    #define INTERFACE_GRAPHICS2      0x00030004
    
    #define INTERFACE_BRIDGE         0x00040000
    
    // Constant: INTERFACE_BLOCK
    // Identifies the <BLOCKCOMMANDS> set
    #define INTERFACE_BLOCK          0x00050000

    #define INTERFACE_SCSI           0x00060000
    
    // Constant INTERFACE_ATABUS
    // Identifies the <ATABUSCOMMANDS> set
    #define INTERFACE_ATABUS         0x00070000

    // Constant INTERFACE_FILE
    // Identifies the <FILECOMMANDS> set
    #define INTERFACE_FILE           0x00080000
    #define INTERFACE_FILESEGMENT    0x00080001
    #define INTERFACE_FILENAME       0x00080002

