' Summary: driverutil.bi
' Contains some additional driver utilities in the mos core library
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#ifndef DRIVERUTIL_BI
#define DRIVERUTIL_BI

#include "query.bi"

' Class: MCQueryUtility
' Event handler that simplifies syscommand_queryinterfaces calls
' Instantiate one instance of this class, then call the function for 
' each interface that needs to be publicly exposed
Type MCQueryUtility Extends QueryListener
        
    ' Variable: mHandles
    ' internal variable containing the list of exposed interfaces
    mHandles As Integer Ptr
    ' Variable: mHandleCount
    ' internal variable containing the amount of exposed interfaces
    mHandleCount As Integer

    ' Function: AddInterface
    ' Adds an interface to be exposed
    ' 
    ' Input:
    '     interface - the ID of the interface, from <DRIVERINTERFACES>
    '
    ' Output:
    '     none
    '
    Declare Sub AddInterface(ByVal interface As Integer)

    ' Function: RemoveInterface
    ' Removes an interface from the exposed list
    ' 
    ' Input:
    '     interface - the ID of the interface, from <DRIVERINTERFACES>
    '
    ' Output:
    '     none
    '
    Declare Sub RemoveInterface(ByVal interface As Integer)

    ' Function: AnnounceDriver
    ' Registers this driver as an endpoint. 
    '
    ' Input: 
    '     deviceid - the ID of the device to which this driver is assigned
    '
    ' Output:
    '     none
    '
    Declare Sub AnnounceDriver(ByVal deviceid As Integer)

    ' Function: queryinterfaces
    ' Handle the actual query message
    '
    Declare Virtual Sub queryinterfaces (ByVal channel As Byte Ptr)

    Declare Constructor()
    Declare Destructor
End Type

#endif

