' Summary: fs.bi
' Contains the message interface for filesystem devices
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

Const FSCOMMANDBASE = &H80000

' Enumeration: FSCOMMANDS
' Lists the commands supported by block-oriented devices
Enum FSCOMMANDS
    FSCOMMAND_MOUNT = FSCOMMANDBASE + 0    
    FSCOMMAND_UNMOUNT = FSCOMMANDBASE + 1
    FSCOMMAND_MOUNTACK = FSCOMMANDBASE + 2
    FSCOMMAND_STATNAME = FSCOMMANDBASE + 3
    FSCOMMAND_STATRESULT = FSCOMMANDBASE + 4
    FSCOMMAND_OPEN = FSCOMMANDBASE + 5
    FSCOMMAND_OPENACK = FSCOMMANDBASE + 6
    FSCOMMAND_CLOSE = FSCOMMANDBASE + 7
    FSCOMMAND_CLOSEACK = FSCOMMANDBASE + 8    
    FSCOMMAND_MAP = FSCOMMANDBASE + 9
    FSCOMMAND_MAPACK = FSCOMMANDBASE + 10

End Enum

Declare Sub FS_MountReq(ByVal sender As Integer, ByVal requestId As Integer)
Declare Sub FS_UnmountReq(ByVal sender As Integer, ByVal requestId As Integer)
Declare Sub FS_StatReq(ByVal sender As Integer, ByVal requestId As Integer, ByRef volumepath As String)
Declare Sub FS_MountAck(ByVal sender As Integer, ByVal requestId As Integer)
Declare Sub FS_MountNak(ByVal sender As Integer, ByVal requestId As Integer)
Declare Sub FS_StatAck(ByVal sender As Integer, ByVal requestId As Integer, ByVal flags As Integer, ByVal Filesize As Long, ByVal Disksize As Long, ByRef volumepath As String)