' Summary: gfx.bi
' Contains the interface for graphics drivers
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

Enum PIXELFORMAT
  'standard 8 bit modes
    PF_N8       = 1
    PF_R3G3B2   = 2
    PF_R2G2B2X2 = 3
    PF_R2G2B2A2 = 4

  'standard 16 bit modes
    PF_R4G4B4X4 = 5
    PF_R4G4B4A4 = 6
    PF_R6G5B5X1 = 7
    PF_R6G5B5A1 = 8
    PF_R5G6B5   = 9

  'standard 24 bit modes
    PF_R8G8B8   = 10
    PF_B8G8R8   = 11

  'standard 32 bit modes
    PF_R8G8B8X8 = 12
    PF_R8G8B8A8 = 13


  ' 4 bit modes (EGA modes)
    PF_R1G1B1I1LSB = 14
    PF_R1G1B1I1MSB = 15
    PF_N4LSB       = 16
    PF_N4MSB       = 17
    PF_I4LSB       = 18
    PF_I4MSB       = 19
    PF_8R1_8G1_8B1_8I1 = 20
    PF_8N1_8N1_8N1_8N1 = 21

End Enum

Const GFXCOMMANDBASE = &H30000

' Enumeration: GFXCOMMANDS
' Lists the commands supported by display drivers
Enum GFXCOMMANDS
    ' startup and shutdown
    GFXCOMMAND_BIND = GFXCOMMANDBASE + 0
    GFXCOMMAND_UNBIND = GFXCOMMANDBASE + 1
    ' deal with the image flow
    GFXCOMMAND_SETCONNECTOR = GFXCOMMANDBASE + 2
    GFXCOMMAND_SETENGINE = GFXCOMMANDBASE + 3
    GFXCOMMAND_GETCONNECTOR = GFXCOMMANDBASE + 4
    GFXCOMMAND_GETENGINE = GFXCOMMANDBASE + 5
    GFXCOMMAND_RANGECONNECTOR = GFXCOMMANDBASE + 6
    GFXCOMMAND_RANGEENGINE = GFXCOMMANDBASE + 7
    ' push commands
    GFXCOMMAND_GLMESSAGE = GFXCOMMANDBASE + 8
    
End Enum

' Enumeration: GFXPROPS
' Lists the various properties of a graphics card component
Enum GFXPROPS
    ' common properties
    GFX_PROP_ENABLE = 0
    GFX_PROP_INPUT = 1
    GFX_PROP_WIDTH = 2
    GFX_PROP_HEIGHT = 3
    
    ' engine properties
    GFX_PROP_CLIP = 4
    GFX_PROP_UNIT_WIDTH = 5
    GFX_PROP_UNIT_HEIGHT = 6
    GFX_PROP_TRANSLATEX = 7
    GFX_PROP_TRANSLATEY = 8
    GFX_PROP_STORE_WIDTH = 9
    GFX_PROP_STORE_HEIGHT = 10
    GFX_PROP_STORE_BITS = 11
    GFX_PROP_SOURCE_WIDTH = 12
    GFX_PROP_SOURCE_HEIGHT = 13
    GFX_PROP_GL_VERSION = 14
    GFX_PROP_GLES_VERSION = 15
    GFX_PROP_STATE_BLOCK = 16
    GFX_PROP_OPERATOR_INDEX = 17
    GFX_PROP_OPERATOR_OPCODE = 18
    GFX_PROP_OPERATOR_ARG_1 = 19
    GFX_PROP_OPERATOR_ARG_2 = 20
    GFX_PROP_OPERATOR_ARG_3 = 21
    GFX_PROP_COLOR_BITS = 22
    GFX_PROP_GL_TARGET = 23

    GFX_PROP_PALETTE = 1024         ' to be deprecated
    GFX_PROP_BUFFER = 1025          ' to be deprecated
    GFX_PROP_TILESHEET = 1026       ' to be deprecated

    ' connector properties
    GFX_PROP_SIGNAL = 23
    GFX_PROP_CONNECTOR_TYPE = 24
    GFX_PROP_VGA_H_FRONT_PORCH = 25
    GFX_PROP_VGA_H_BACK_PORCH = 26
    GFX_PROP_VGA_H_SYNC = 27
    GFX_PROP_VGA_V_FRONT_PORCH = 28
    GFX_PROP_VGA_V_BACK_PORCH = 29
    GFX_PROP_VGA_V_SYNC = 30
    GFX_PROP_DOT_CLOCK = 31
    GFX_PROP_VGA_H_SYNC_POL = 32
    GFX_PROP_VGA_V_SYNC_POL = 33
End Enum

' Enumeration: GFXCLIP
' Lists possible output clipping states
Enum GFXCLIP
    GFX_CLIP_PASS = 0
    GFX_CLIP_WRAP = 1
    GFX_CLIP_MEM_H = 2
    GFX_CLIP_MEM_V = 3
End Enum

' Enumeration: GFXSIGNALS
' Lists possible output signal compositions
Enum GFXSIGNALS
    GFX_SIGNAL_HIDDEN = 0   ' Integrated (when the display device is inseparable from the graphics controller, including LED displays and emulated displays)
    GFX_SIGNAL_INTEGRATED = 0
    GFX_SIGNAL_RGBHV = 1    ' VGA
    GFX_SIGNAL_RGBS = 2
    GFX_SIGNAL_RGSB = 3
    GFX_SIGNAL_YPBPR = 4    ' Component
    GFX_SIGNAL_DVID = 5
    GFX_SIGNAL_YUV = 6      ' (PAL)
    GFX_SIGNAL_YIQ = 7      ' (NTSC)
    GFX_SIGNAL_Y_UV = 8     ' Separated Y and UV (PAL S-Video)
    GFX_SIGNAL_Y_IQ = 9     ' Separated Y and IQ (NTSC S-Video)
    GFX_SIGNAL_HDMI = 10
    GFX_SIGNAL_TEXT = 11
    GFX_SIGNAL_CUSTOM = 12  ' Internal (proprietary)
    ' add RF standards
End Enum

' Enumeration: GFXCONNECTOR
' Lists possible physical connections
Enum GFXCONNECTOR
    GFX_CONNECTOR_HIDDEN = 0
    GFX_CONNECTOR_VGA = 1
    GFX_CONNECTOR_DVI = 2
    GFX_CONNECTOR_SVIDEO = 3
    GFX_CONNECTOR_COMPONENT = 4
    GFX_CONNECTOR_HDMI = 5
    GFX_CONNECTOR_RF = 6
    GFX_CONNECTOR_SCART = 7
    GFX_CONNECTOR_COMPOSITE = 8
End Enum

' Enumeration: GFXCONNECTOR
' Lists the operations that can be used to describe video output
Enum GFXOPCODE
    GFX_OPERATOR_RGB    =  0 ' output = (color) red(a1) + green(a2) + blue(a3) (each component is UDI_GFX_PROP_COLOR_BITS
    GFX_OPERATOR_YUV    =  1 ' output = (color) Y(a1) + U(a2) + V(a3)
    GFX_OPERATOR_YIQ    =  2 ' output = (color) Y(a1) + I(a2) + Q(a3)
    GFX_OPERATOR_I      =  3 ' output = (color) intensity(a1)
    GFX_OPERATOR_ALPHA  =  4 ' output = (color) a1 + alpha(a2)
    GFX_OPERATOR_ADD    =  5 ' output = a1 + a2 + v3
    GFX_OPERATOR_SUB    =  6 ' output = a1 - a2 - v3
    GFX_OPERATOR_MUL    =  7 ' output = a1 * a2
    GFX_OPERATOR_DIV    =  8 ' output = a1 / a2
    GFX_OPERATOR_MAD    =  9 ' output = a1 * a2 + a3
    GFX_OPERATOR_FRC    = 10 ' output = a1 * (a2 / a3)
    GFX_OPERATOR_SHR    = 11 ' output = a1 >> (a2 + v3)
    GFX_OPERATOR_SHL    = 12 ' output = a1 << (a2 + v3)
    GFX_OPERATOR_ROR    = 13 ' output = a1 >> a2 (over a3 bits)
    GFX_OPERATOR_ROL    = 14 ' output = a1 << a2 (over a3 bits)
    GFX_OPERATOR_SAR    = 15 ' output = a1 >> a2 (width is a3 bits, i.e. empties are filled with bit a3-1)
    GFX_OPERATOR_SAL    = 16 ' output = a1 <<< (a2 + v3) (empties filled with bit 0)
    GFX_OPERATOR_AND    = 17 ' output = a1 & a2
    GFX_OPERATOR_OR     = 18 ' output = a1 | a2 | v3
    GFX_OPERATOR_NOT    = 19 ' output = ~a1
    GFX_OPERATOR_XOR    = 20 ' output = a1 | a2 | v3
    GFX_OPERATOR_NEG    = 21 ' output = -a1
    GFX_OPERATOR_SEG    = 22 ' output = (a1 >> v2) & (2**v3-1) (select v3 bits starting from bit v2)
    GFX_OPERATOR_RANGE  = 23 ' output = (a1 > a2) ? a2 : ((a1 < a3) ? a3 : a1)
    GFX_OPERATOR_CONST  = 24 ' output = v1
    GFX_OPERATOR_ATTR   = 25 ' output = property[a1 + v2]
    GFX_OPERATOR_SWITCH = 26 ' output = output[a1 + v2]
    GFX_OPERATOR_BUFFER = 27 ' output = buffer[a1][a2] (buffer is v3 bits per entry)
    GFX_OPERATOR_X      = 28 ' output = output x pixel
    GFX_OPERATOR_Y      = 29 ' output = output y pixel
    GFX_OPERATOR_TX     = 30 ' output = horizontal tile index belonging to output pixel
    GFX_OPERATOR_TY     = 31 ' output = vertical tile index belonging to output pixel
    GFX_OPERATOR_TXOFF  = 32 ' output = horizontal offset from start of tile
    GFX_OPERATOR_TYOFF  = 33 ' output = vertical offset from start of tile
    GFX_OPERATOR_INPUT  = 34 ' output = input engine[x][y]   component v1
    GFX_OPERATOR_DINPUT = 35 ' output = input engine[a2][a3] component v1
End Enum


' Structure: CRTCsettings
' contains the settings for the VGA signal used to send
' display data to the monitor attached. Used for (S)VGA
' and DVI displays
Type CRTCSettings
    Dim x_active As Integer
    Dim x_frontporch As Integer
    Dim x_sync As Integer
    Dim x_backporch As Integer

    Dim y_active As Integer
    Dim y_frontporch As Integer
    Dim y_sync As Integer
    Dim y_backporch As Integer

    Dim hfreq As Single
    Dim vfreq As Single
    Dim dotclock as Single
End Type

Type GFXDRIVER2
    Connectors As Integer
    Engines As Integer
    setconnectorstate As Function CDecl(ByVal info as Byte Ptr, ByVal index As Integer, ByVal property As Integer, ByVal value As Integer) As Integer
    setenginestate As Function CDecl(ByVal info as Byte Ptr, ByVal index As Integer, ByVal property As Integer, ByVal value As Integer) As Integer
    getconnectorstate As Function CDecl(ByVal info as Byte Ptr, ByVal index As Integer, ByVal property As Integer) As Integer
    getenginestate As Function CDecl(ByVal info as Byte Ptr, ByVal index As Integer, ByVal property As Integer) As Integer
    getconnectorrange As Function CDecl(ByVal info as Byte Ptr, ByVal sender As Integer, ByVal index As Integer, ByVal property As Integer) As Integer
    getenginerange As Function CDecl(ByVal info as Byte Ptr, ByVal sender As Integer, ByVal index As Integer, ByVal property As Integer) As Integer
    gldispatch As Function CDecl(ByVal info As Byte Ptr, ByVal buffer As Byte Ptr, ByVal packetsize As Integer) As Integer
End Type

Declare Sub graphicsmain2(ByRef d As GFXDRIVER2, ByVal info As Byte Ptr)

Declare Sub EngineReturnSimpleRange CDecl Alias "EngineReturnSimpleRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal First as Integer, ByVal Last as Integer, ByVal Modulus As Integer)
Declare Sub ConnectorReturnSimpleRange CDecl Alias "ConnectorReturnSimpleRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal First as Integer, ByVal Last as Integer, ByVal Modulus As Integer)
Declare Sub EngineReturnConstantRange CDecl Alias "EngineReturnConstantRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal Value As Integer)
Declare Sub ConnectorReturnConstantRange CDecl Alias "ConnectorReturnConstantRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal Value As Integer)
Declare Sub EngineReturnBooleanRange CDecl Alias "EngineReturnBooleanRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal Value1 As Integer, ByVal Value2 As Integer)
Declare Sub ConnectorReturnBooleanRange CDecl Alias "ConnectorReturnBooleanRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal Value1 As Integer, ByVal Value2 As Integer)
