;
; Summary: inc_kernel.asm
; *Operating System constants*
;
;
; Author: 
;     Marcel Sondaar
;
; License:
;     Educational Purposes
;

PRIVILEGE_INFO      EQU 0
PRIVILEGE_USER      EQU 1
PRIVILEGE_MONITOR   EQU 2
PRIVILEGE_DRIVER    EQU 3
PRIVILEGE_KERNEL    EQU 4
PRIVILEGE_DISABLED  EQU 5

PRIVILEGE_ALLOW     EQU 0
PRIVILEGE_DISALLOW  EQU 1
PRIVILEGE_ASK       EQU 2

; FIXME: separate inc_kernel for ia and ia32 kernels

; ia32 kernel task descriptor table
TDT_KERNELSTACK     EQU 0
TDT_KERNELSTACKTOP  EQU 4
TDT_PHYSADDR        EQU 8

TDT_FPUSTATE        EQU 512             ; +512 to +1023 for storing FPU and SIMD state

; ia kernel thread description structure
TDS_DESCHEDULE      EQU 0
TDS_LOCALDATA       EQU 4

TDS_BASE_ESP        EQU 4
TDS_BASE_ESP0       EQU 8

; kernel modes
KM_NOPAGING         EQU 0x0
KM_STDPAGING        EQU 0x1
KM_PAEPAGING        EQU 0x2
KM_LMPAGING         EQU 0x3

; Todo: equates to TDT
TSS_SYS_MONITOR     EQU 104
TSS_SYS_MONITORCR3  EQU 108
TSS_SYS_PROCESSOR   EQU 112
TSS_SYS_LEVEL_U     EQU 113
TSS_SYS_LEVEL_M     EQU 114
TSS_SYS_LEVEL_D     EQU 115
TSS_SYS_LEVEL_K     EQU 116
TSS_SYS_TSSLOCK     EQU 117
TSS_SYS_REFCOUNT    EQU 118
TSS_SYS_TASKNAME    EQU 120

; IA Physical Memory Allocator flags
PMAQ_COUNT_NONMEM   EQU 0x0000000000000000
PMAQ_COUNT_MEM      EQU 0x4000000000000000
PMAQ_POINTER_PHYS   EQU 0x8000000000000000
PMAQ_POINTER_VIRT   EQU 0xC000000000000000
PMAD_COUNT_NONMEM   EQU 0x00000000
PMAD_COUNT_MEM      EQU 0x40000000
PMAD_POINTER_PHYS   EQU 0x80000000
PMAD_POINTER_VIRT   EQU 0xC0000000
PMAD_L1COUNT_NONMEM EQU 0x00000000
PMAD_L1COUNT_MEM    EQU 0x80000000
PMAB_COUNT_NONMEM   EQU 0x00
PMAB_COUNT_MEM      EQU 0x40
PMAB_POINTER_PHYS   EQU 0x80
PMAB_POINTER_VIRT   EQU 0xC0
PMAB_L1COUNT_NONMEM EQU 0x00
PMAB_L1COUNT_MEM    EQU 0x80


; IA kernel processor detection
PROC_INTEL          EQU 64              ; Intel processor
PROC_AMD            EQU 128             ; AMD processor
PROC_CYRIX          EQU 192             ; other procs, help me
PROC_XXXX1          EQU 208
PROC_XXXX2          EQU 224

PROC_UNKNOWN        EQU 0               ; could not establish processor identity

PROC_I386           EQU PROC_INTEL+0    ; Intel 386
PROC_I486           EQU PROC_INTEL+1    ; Intel 486 SX or DX
PROC_I586           EQU PROC_INTEL+2    ; Pentium 1
PROC_I586MMX        EQU PROC_INTEL+3    ; Pentium MMX
PROC_I686           EQU PROC_INTEL+4    ; Pentium Pro/II/III
PROC_I686P4         EQU PROC_INTEL+6    ; Pentium IV  - Willamette, Northwood, Prescott, Galatin, Cedar Mill
PROC_I686CD         EQU PROC_INTEL+7    ; Core Duo    - Conroe, Allendale, Meron

PROC_AK5            EQU PROC_AMD+0      ; AMD K5
PROC_AK6            EQU PROC_AMD+1      ; AMD K6
PROC_ADURON         EQU PROC_AMD+2      ; Duron
PROC_ASEMPRON       EQU PROC_AMD+3      ; Sempron
PROC_AATHLON        EQU PROC_AMD+4      ; Athlon      - K7, Thunderbird
PROC_AATHLONXP      EQU PROC_AMD+5      ; Athlon XP   - Palonimo, Thoroughbred, Thorton, Barton
PROC_AATHLON64      EQU PROC_AMD+6      ; Athlon64
PROC_AATHLONX2      EQU PROC_AMD+7      ; Athlon64 X2
PROC_AATHLONFX      EQU PROC_AMD+8      ; Athlon FX

PROC_C4x86          EQU PROC_CYRIX+0    ; Cyrix 4x86
PROC_C5x86          EQU PROC_CYRIX+1    ; Cyrix 5x86
PROC_C6x86          EQU PROC_CYRIX+2    ; Cyrix 6x86
PROC_C6x86MX        EQU PROC_CYRIX+3    ; Cyrix 6x86 with MMX
PROC_CMEDIAGX       EQU PROC_CYRIX+4    ; Media GX