;
; Summary: inc_syscall.asm
; *Listing of kernel functions available in userspace*
;
; Author:
;     Marcel Sondaar
;
; License:
;     Educational Purposes
;

k_KernelVersion     EQU 0x00000000
k_MemMap            EQU 0x00010000
k_BlockAlloc        EQU 0x00020000
k_GetTimerTicks     EQU 0x00030000
k_PortAlloc         EQU 0x00040000
k_GetCpuInfo        EQU 0x00050000
k_CreateThread      EQU 0x00060000
k_RouteAlloc        EQU 0x00070000
k_RouteFind         EQU 0x00080000
k_GateAlloc         EQU 0x00090000
k_GateLookup        EQU 0x000A0000
k_CreateVTask       EQU 0x000B0000

; Macro: kernel
; expands to the system call given as parameter
%macro kernel 1
       MOV EAX, k_%1
       INT 0x30
%endmacro
