' Summary: mos.bi
' The FreeBasic include for the MOS kernel interface
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'
' Defines:
'     <blockalloc> <gatealloc> <gatelookup> <gettimerticks> <getcpuinfo>
'     <kernelversion> <localipccall> <memmap> <portalloc> <routealloc> <routefind>
'
' Linker Parameters:
'     -lmos
'

Type mos_procinfo
    processor_id As Unsigned Short
    processor_version As Unsigned Short
    processor_caps1 As Unsigned Long
    processor_caps2 As Unsigned Long
    processor_brand As String * 12
End Type

Function PORTNAME (s As String) As Unsigned Integer
    PORTNAME = asc(mid(s,1,1)) + _
               asc(mid(s,2,1)) * 256 + _
               asc(mid(s,3,1)) * 256 * 256 + _
               asc(mid(s,4,1)) * 256 * 256 * 256
End Function

Function MANGLE (f as Long, g As Long)
    MANGLE = f * 65536 + g
End Function

Declare Function blockalloc Cdecl Alias "blockalloc" (ByVal size As Long, ByVal base As Byte Ptr) As Long
Declare Function gatealloc CDecl Alias "gatealloc" (ByVal address As Sub()) As Long
Declare Function gatelookup CDecl Alias "gatelookup" (ByVal gate As Long, ByVal paddress As Sub() Ptr ) As Long
Declare Function gettimerticks Cdecl Alias "gettimerticks" () as Long
Declare Function getcpuinfo Cdecl Alias "getcpuinfo" (ByVal processor as Long, ByVal structure As mos_procinfo Ptr) As Long
Declare Function kernelversion Cdecl Alias "kernelversion" () as Long
Declare Function memmap Cdecl Alias "memmap" (ByVal size As Long, ByVal base As Any Ptr, ByVal target As Any Ptr) As Long
Declare Function portalloc Cdecl Alias "portalloc" (ByVal base As Long, ByVal ports As Long) As Long
Declare Function routealloc Cdecl Alias "routealloc" (ByVal port As Long, ByVal name As Unsigned Integer) As Long
Declare Function routefind Cdecl Alias "routefind" (ByVal name As Unsigned Long) As Long
Declare Function createvtask Cdecl Alias "createvtask" (ByVal address As Long, ByVal target As Any Ptr) As Long

Declare Function ipccdeclconv CDecl Alias "ipccdeclconv" (ByVal Address As Sub(ByVal Long, ByVal Long, ByVal Long, ByVal Long)) As Long
Declare Function localipccall CDecl Alias "localipccall" (ByVal address as Sub(), ByRef param1 As Long, ByRef param2 As Long, ByRef param3 As Long, ByRef param4 As Long)