/*
        Summary: mos.h
        *The header file for kernel interface library*

        Author:
            Marcel Sondaar

        License:
            Educational Purposes

        Defines:
            <blockalloc> <gatealloc> <gatelookup>
            <getcpuinfo> <gettimerticks>
            <ipccdeclconv> <kernelversion>
            <localipccall> <memmap> <portalloc>
            <routealloc> <routefind>

        Linker Parameters:
            -lmos
*/

#ifndef _MOS_H_
#define _MOS_H_


/* Structure: mos_procinfo
 * stores processor info
 */
typedef struct mos_procinfo
{
    // Variable: processor_id
    // shorthand number of the processor
    unsigned short int processor_id;
    // Variable: Processor_version
    // packed processor version
    unsigned short int processor_version;
    // Variable: processor_caps1
    // processor capabilities bits set 1
    unsigned int processor_caps1;
    // Variable: processor_caps2
    // processor capabilities bits set 2
    unsigned int processor_caps2;
    // Variable: processor_brand
    // fixed-length string containing the processor manufacturer
    char processor_brand[12];
} mos_procinfo;

#ifdef __CPLUSPLUS__
extern "C" {
#endif

    int blockalloc(int size, void * base);
    int gatealloc(void (*address)(void));
    int gatelookup(int gate, void (**paddress)(void) );
    int getcpuinfo(int processor, mos_procinfo * pinfo);
    int gettimerticks();
    int kernelversion();
    int memmap(int size, void * base, void * target);
    int portalloc(int base, int ports);
    int routealloc(int port, unsigned int name);
    int routefind(unsigned int name);
    int createvtask(unsigned int startaddress, void * target);    

    int localipccall(void (*address)(void), void * param1, void * param2, void * param3, void * param4);
    int ipccdeclconv(void (*address)(int,int,int,int));

#ifdef __CPLUSPLUS__
}
#endif

/* Macro: PORTNAME
   Generates a FourCC out of a string's first four characters */
#define PORTNAME(s) ( ((unsigned int) s[0]) | ((unsigned int) s[1]) << 8 | ((unsigned int) s[2]) << 16 | ((unsigned int) s[3]) << 24)


#endif
