' Summary: blobs.bi
' The FreeBasic include for the Blobs User Interface
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'


' Enumeration: BLOBSCALLS
' This enumeration lists all the defined calls to a BLOBS compatible host
'
' the host manages a screen, and divides it into viewports, where each
' viewport can be accessed independently
'
' Derived from: none
'
' Derivatives: none
'
' See also: <BLOBSWINDOWCALLS>
'

Enum BLOBSCALLS

    ' Constant: BLOBS_CREATEWINDOW
    ' this attempts to create a viewport
    '
    ' The location of the viewport is indeterminate, as well as actual
    ' visibility. If the viewport can not be made visible in its entirety,
    ' the interface should provide a means to the user to bring it to the
    ' foreground.
    '
    ' The implementation defines the limitations of when a viewport
    ' can be created, which may mean that creation can be refused if 
    ' viewports are already present. The implementation should at minimum
    ' support one viewport the size of the screen or less.
    '
    ' The implementation may interpret the input size in any linear system
    ' instead of pixels, such as characters. Consequently the actual size
    ' in pixels may be not be specified exactly but only as a multiple of
    ' a certain value. You should call <BLOBS_WINDOWDIMENSIONS> to retrieve
    ' the scaling involved
    '
    ' in:
    '     Parameter 1 - call gate information
    '     Parameter 2 - width (in implemention specified units)
    '     Parameter 3 - height (in implemention specified units)
    '     Parameter 4 - undefined
    '
    ' out:
    '     Parameter 1 - gate allocated, or -1 on failure
    '
    ' destroyed:
    '     all other inputs
    '
    BLOBS_CREATEWINDOW = 0
    
    ' Todo: Documentation
    '
    BLOBS_WINDOWDIMENSIONS = 1


End Enum

' Enumeration: BLOBSWINDOWCALLS
' This enumeration lists all the defined calls to a BLOBS compatible viewport.
'
' These can be roughly divided into two categories: graphics primitives,
' and helper functions.
'
' Derived from: <GFXPRIMITIVES>
'
' Derivatives: none
'
' See also: <BLOBSCALLS>
'

Enum BLOBSWINDOWCALLS
    ' Constant: BLOBS_SETPIXEL
    ' see: <GFXPRIMITIVES.GFX_SETPIXEL>
    BLOBS_SETPIXEL = 16

    ' Constant: BLOBS_SETCHAR
    ' see: <GFXPRIMITIVES.GFX_SETCHAR>
    BLOBS_SETCHAR = 17

    ' Constant: BLOBS_PRINTCHAR
    ' Call index for character streams
    '
    ' This call emulates the effect of a console.
    ' Characters are emitted in order, wrapping around the ends of the screen.
    ' Special characters like newline or linefeed \n and \r work as they would
    ' on an printer, meaning that you have to emit both characters to continue
    ' at the start of the next line.
    '
    ' in:
    '     Parameter 1 - call gate information
    '     Parameter 2 - character
    '     Parameter 3 - undefined
    '     Parameter 4 - undefined
    '
    ' out:
    '     none
    '
    ' destroyed:
    '     all other inputs
    '
    BLOBS_PRINTCHAR = 128
End Enum
