' Summary: gfx.bi
' The FreeBasic include for the Graphics Driver Interface
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'


' Enumeration: GFXCALLS
' This enumeration lists all the defined calls controlling a display driver
'
' Derived from: none
'
' Derivatives: none
'
' See also: none
'
'
Enum GFXCALLS
    GFX_INFO = 0
    GFX_GETSTATUS = 1
    GFX_GETMODE = 2
    GFX_GETFONT = 3
End Enum


' Enumeration: GFXPRIMITIVES
' This enumeration lists all the basic primitives a graphics card might support
'
' Derived from: none
'
' Derivatives: <BLOBSWINDOWCALLS>
'
' See also: none
'
Enum GFXPRIMITIVES
    
    ' Constant: GFX_SETPIXEL
    ' Call index for setting a pixel
    '
    ' The pixel addressed is computed in screen coordinates
    ' (i.e. counting from top-left) rather than mathematical
    ' coordinates used in some systems.
    '
    ' in:
    '     Parameter 1 - call gate information
    '     Parameter 2 - x location
    '     Parameter 3 - y location
    '     Parameter 4 - color
    '
    ' out:
    '     none
    '
    ' destroyed:
    '     all other inputs
    '
    GFX_SETPIXEL = 16

    ' Constant: GFX_SETCHAR
    ' Call index for drawing a character
    '
    ' note that characters are a multiple of pixels,
    ' and that the x and y location are scaled to address
    ' adjacent character cells. I.e. when x is increased
    ' by one the character is drawn immediately next to the
    ' previous characters, rather than overwriting it
    '
    ' Mainly to support text modes, the pixels used to show
    ' the character are left in an undefined state, and
    ' writing one pixel over a character may cause the
    ' entire character to disappear
    '
    ' in:
    '     Parameter 1 - call gate information
    '     Parameter 2 - x location
    '     Parameter 3 - y location
    '     Parameter 4 - character code
    '
    ' out:
    '     none
    '
    ' destroyed:
    '     all other inputs
    '
    GFX_SETCHAR = 17
End Enum
