/*
    Summary: wchar.h
    *The libc wide character functions header*

    Author:
        Marcel "(Com)Buster" Sondaar

    License:
        Public Domain

*/

/*

   7.24 Extended multibyte and wide character utilites <wchar.h>

   This file is part of the Public Domain C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#ifndef _PDCLIB_WCHAR_H
#define _PDCLIB_WCHAR_H _PDCLIB_WCHAR_H

#ifndef _PDCLIB_CONFIG_H
#define _PDCLIB_CONFIG_H _PDCLIB_CONFIG_H
#include <_PDCLIB_config.h>
#endif

#ifndef _PDCLIB_INT_H
#define _PDCLIB_INT_H _PDCLIB_INT_H
#include <_PDCLIB_int.h>
#endif

/*
 *  7.24.1
 */

#ifndef _PDCLIB_SIZE_T_DEFINED
#define _PDCLIB_SIZE_T_DEFINED _PDCLIB_SIZE_T_DEFINED
typedef _PDCLIB_size_t size_t;
#endif

#ifndef _PDCLIB_WCHAR_T_DEFINED
#define _PDCLIB_WCHAR_T_DEFINED _PDCLIB_WCHAR_T_DEFINED
typedef _PDCLIB_wchar_t wchar_t;
#endif

#ifndef _PDCLIB_WINT_T_DEFINED
#define _PDCLIB_WINT_T_DEFINED _PDCLIB_WINT_T_DEFINED
typedef _PDCLIB_wint_t wint_t;
#endif

/* missing:
 * - wint_t
 * - WEOF
 * - struct tm
 * WCHAR_MIN
 * WCHAR_MAX
 */

/* todo: build struct and move it */
typedef int mbstate_t;

#define NULL _PDCLIB_NULL


#ifdef _PDCLIB_STDIO_H
#include <_PDCLIB_wstdio.h>
#endif

/*
 * 7.24.4
 *
 */

double wcstod(const wchar_t * _PDCLIB_restrict nptr, wchar_t ** _PDCLIB_restrict endptr);
float wcstof(const wchar_t * _PDCLIB_restrict nptr, wchar_t ** _PDCLIB_restrict endptr);
long double wcstold(const wchar_t * _PDCLIB_restrict nptr, wchar_t ** _PDCLIB_restrict endptr);
long int wcstol(const wchar_t * _PDCLIB_restrict nptr, wchar_t ** _PDCLIB_restrict endptr, int base);
long long int wcstoll(const wchar_t * _PDCLIB_restrict nptr, wchar_t ** _PDCLIB_restrict endptr, int base);
unsigned long int wcstoul(const wchar_t * _PDCLIB_restrict nptr, wchar_t ** _PDCLIB_restrict endptr, int base);
unsigned long long int wcstoull(const wchar_t * _PDCLIB_restrict nptr, wchar_t ** _PDCLIB_restrict endptr, int base);

wchar_t * wcscpy(wchar_t * _PDCLIB_restrict s1, const wchar_t * _PDCLIB_restrict s2);
wchar_t * wcsncpy(wchar_t * _PDCLIB_restrict s1, const wchar_t * _PDCLIB_restrict s2, size_t n);
wchar_t * wmemcpy(wchar_t * _PDCLIB_restrict s1, const wchar_t * _PDCLIB_restrict s2, size_t n);
wchar_t * wmemmove(wchar_t * _PDCLIB_restrict s1, const wchar_t * _PDCLIB_restrict s2, size_t n);

wchar_t * wcscat(wchar_t * _PDCLIB_restrict s1, const wchar_t * _PDCLIB_restrict s2);
wchar_t * wcsncat(wchar_t * _PDCLIB_restrict s1, const wchar_t * _PDCLIB_restrict s2, size_t n);

int wcscmp(const wchar_t * s1, const wchar_t * s2);
int wcscoll(const wchar_t * s1, const wchar_t * s2);
int wcsncmp(const wchar_t * s1, const wchar_t * s2, size_t n);
size_t wcsxfrm(wchar_t * _PDCLIB_restrict s1, const wchar_t * _PDCLIB_restrict s2, size_t n);
int wmemcmp(const wchar_t * s1, const wchar_t * s2, size_t n);

wchar_t * wcschr(const wchar_t * s, wchar_t c);
size_t wcscspn(const wchar_t * s1, const wchar_t * s2);
wchar_t * wcspbrk(const wchar_t * s1, const wchar_t * s2);
wchar_t * wcsrchr(const wchar_t * s, wchar_t c);
size_t wcsspn(const wchar_t * s1, const wchar_t * s2);
wchar_t * wcsstr(const wchar_t * s1, const wchar_t * s2);
wchar_t * wcstok(wchar_t * _PDCLIB_restrict s1, const wchar_t * _PDCLIB_restrict s2, wchar_t ** _PDCLIB_restrict ptr);
wchar_t * wmemchr(const wchar_t * s, wchar_t c, size_t n);

size_t wcslen(const wchar_t * s);
wchar_t * wmemset(wchar_t * s, wchar_t c, size_t n);

/*
 * 7.24.5
 *
 * missing:
 * wcsftime
 */


/*
 * 7.24.6
 */



int mbsinit(const mbstate_t *ps);

size_t mbrlen(const char * _PDCLIB_restrict s, size_t n, mbstate_t * _PDCLIB_restrict ps);
size_t mbrtowc(wchar_t * _PDCLIB_restrict pwc, const char * _PDCLIB_restrict s, size_t n, mbstate_t * _PDCLIB_restrict ps);
size_t wcrtomb(char * _PDCLIB_restrict s, size_t n, mbstate_t * _PDCLIB_restrict ps);

size_t mbsrtowcs(wchar_t * _PDCLIB_restrict dst, const char ** _PDCLIB_restrict src, size_t len, mbstate_t * _PDCLIB_restrict ps);
size_t wcsrotmbs(char * _PDCLIB_restrict dst, const wchar_t ** _PDCLIB_restrict src, size_t len, mbstate_t * _PDCLIB_restrict ps);

#endif

