ORG 7C00h

BITS 16
CPU 386

;
; Summary: stage1_ia32_pc.asm
; *The stage 1 bootloader for My Operating System (MOS)*
;
; Loads stage 2 from the booted floppy, and
; returns a message if an error occurs
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

start:                  JMP loader

                        TIMES 0Bh-$+start DB 0
bpbBytesPerSector:  	DW 512
bpbSectorsPerCluster: 	DB 1
bpbReservedSectors: 	DW 1
bpbNumberOfFATs: 	    DB 2
bpbRootEntries: 	    DW 224
bpbTotalSectors: 	    DW 2880
bpbMedia: 	            DB 0xF0
bpbSectorsPerFAT: 	    DW 9
bpbSectorsPerTrack: 	DW 18
bpbHeadsPerCylinder: 	DW 2
bpbHiddenSectors: 	    DD 0
bpbTotalSectorsBig:     DD 0
bsDriveNumber: 	        DB 0
bsUnused: 	            DB 0
bsExtBootSignature: 	DB 0x29
bsSerialNumber:	        DD 0xa0a1a2a3
bsVolumeLabel: 	        DB "MOS FLOPPY "
bsFileSystem: 	        DB "FAT12   "

loader:         XOR AX, AX
                MOV DS, AX
                MOV ES, AX

                MOV SS, AX
                MOV SP, 0x7C00

                MOV [bsDriveNumber], DL

                LEA SI, [WelcomeMessage]

lpprint:        MOV AH, 0eh
                MOV AL, [SI]
                OR AL, AL
                JZ endprint
                INT 10h
                INC SI
                JMP lpprint

endprint:       MOV AL, [bpbNumberOfFATs]
                MOV BX, [bpbSectorsPerFAT]
                MOV DX, [bpbReservedSectors]

lpfindsector:   ADD DX, BX
                DEC AL
                JNZ lpfindsector
                MOV [DataOffset], DX

                CALL LoadSector
                MOV BX, 0
trynextentry:   LEA DI, [scratchspace + BX]
                LEA SI, [StageString]
                MOV CX, 11
                CLD
                REPE CMPSB
                JE foundstage
                MOV AL, [scratchspace + BX]
                CMP AL, 0
                JE notfound
                ADD BX, 32
                CMP BX, 512
                JNE trynextentry

notfound:       LEA SI, [ErrorString]
lpprinterror:   MOV AH, 0eh
                MOV AL, [SI]
                OR AL, AL
                JZ finishederror
                INT 10h
                INC SI
                JMP lpprinterror
finishederror:  JMP $


foundstage:     MOV AX, [scratchspace + BX + 26]
                MOV CX, [bpbRootEntries]
                SHR CX, 4
                SUB CX, 2
                ADD [DataOffset], CX

nextentry:      PUSH AX

                MOV DX, 0
                MOV CL, [bpbSectorsPerCluster]
                MOV CH, 0
sectorsclusters:ADD DX, AX
                LOOP sectorsclusters
                ADD DX, [DataOffset]

                Call LoadSector

                MOV DI, [ImageOffset]
                LEA SI, [scratchspace]
                MOV CX, 512
                MOV AX, 0x1000
                MOV ES, AX

                CLD
                REP MOVSB
                MOV [ImageOffset], DI

                PUSH CS
                POP ES

                POP AX
                MOV CX, AX
                SHR CX, 1
                ADD CX, AX
                SHR CX, 9
                MOV DX, CX
                INC DX
                PUSH AX
                Call LoadSector

                POP AX
                MOV BX, AX
                SHR BX, 1
                ADD BX, AX
                AND AX, 1
                JNZ fatodd

                MOV AX, [scratchspace+BX]
                AND AX, 0x0FFF
                JMP gotnext
fatodd:         MOV AX, [scratchspace+BX]
                SHR AX, 4
gotnext:        MOV BX, AX
                AND BX, 0x0FF0
                SUB BX, 0x0FF0
                JZ loadcomplete
                JMP nextentry

loadcomplete:   MOV DL, [bsDriveNumber]
                JMP 0x1000:0x0000

                ; LoadSector, DX = sectorno.
LoadSector:     PUSH DX
                MOV CX, 3
                PUSH CX
LoadSectorRedo: MOV CL, [bpbSectorsPerTrack]
                MOV AL, [bpbHeadsPerCylinder]
                MUL CL                          ;AX = AL * CL
                MOV CH, 0
                MOV BX, 0
LoadSectorCyl:  CMP DX, AX
                JNGE LoadSectorHd
                INC BX
                SUB DX, AX
                JMP LoadSectorCyl
LoadSectorHd:   CMP DL, CL
                JNGE LoadSectorDo
                SUB DL, CL
                INC CH
                JMP LoadSectorHd
LoadSectorDo:   MOV DH, CH
                MOV CL, DL
                MOV CH, BL
                MOV DL, [bsDriveNumber]
                MOV AX, 0x0201
                MOV BX, scratchspace
                INC CL
                STC
                INT 13h
                STI
                POP CX
                POP DX
                JC LoadSectorTry
LoadSectorEnd:  RET

LoadSectorTry:  DEC CX
                JZ LoadSectorEnd
                PUSH DX
                PUSH CX
                JMP LoadSectorRedo

ImageOffset     DW  0
DataOffset      DW  0
StageString     DB  "STAGE2  BIN"
ErrorString     DB  "Could not load stage 2", 13, 10, 0
WelcomeMessage  DB  "MOS V1.3.0 bootloader executing", 13, 10, 0

TIMES 510-$+start DB 0
DB 055h, 0AAh

scratchspace: