ORG 400000h
BITS 32

;
; Summary: stage4_ia32_pc.asm
; *The bootstrap user module*
;
; Although replacing this module with another can allow the
; user to run an effectively different operating system, this
; is currently the default.
;
; Checks and loads all modules present in the ramdisk and
; starts each of them
;
; Author:
;     Marcel Sondaar
;
; License:
;     Educational purposes
;

; EAX = ramdisk address in linear memory

CPU 386

%include "inc_syscall.asm"
%include "inc_ia.asm"
%include "inc_elf.asm"

start:              MOV ESP, stackend
                    MOV [iPhysRamdisk], EAX

                    Call allocramdisk
                    Call loadunittable
lbl:
                    ;Call lpcAppBase
                    ;JMP CreateTask

.lbl:               nop
                    nop
                    jmp .lbl

times 0x20-($-$$) nop
                    DD CreateTask

allocramdisk:       XOR EBX, EBX
                    MOV BL, 1
                    MOV ESI, [iPhysRamdisk]
                    MOV EAX, ESI
                    MOV EDI, lpcRamdiskBase
                    AND EAX, PAGE_PARAMMASK
                    ADD EAX, lpcRamdiskBase
                    MOV [lpRamdisk], EAX
                    kernel MemMap

                    MOV EDI, [lpRamdisk]
                    XOR ECX, ECX

.loop:              MOV EAX, [EDI]
                    OR EAX, EAX
                    JZ .done
                    MOV EDX, [EDI+RD_OFFSET]
                    MOV EBX, [EDI+RD_SIZE]
                    ADD EDX, EBX
                    CMP EDX, ECX
                    JNG .notbigger
                    MOV ECX, EDX
.notbigger:         ADD EDI, RD_ENTRYSIZE
                    JMP .loop

.done:              SHR ECX, 12
                    ADD ECX, 1
                    MOV EBX, ECX
                    MOV ESI, [iPhysRamdisk]
                    MOV EDI, lpcRamdiskBase+PAGE_SIZE
                    ADD ESI, PAGE_SIZE
                    kernel MemMap

                    RET

loadunittable:      MOV ECX, lpcAppBase
                    MOV [lpCurrentBase], ECX

                    MOV ECX, [lpRamdisk]
.loop1:             MOV EAX, [ECX+RD_NAME]
                    MOV EBX, [ECX+RD_OFFSET]
                    MOV ESI, [lpRamdisk]
                    MOV EDI, [ECX+RD_SIZE]
                    ADD EBX, ESI
                    OR EAX, EAX
                    JZ .done
                    CMP EAX, 'STAG'
                    JE .skip
                    MOV EAX, EDI
                    PUSH ECX
                    CALL ELF_Load
                    POP ECX
.skip:              ADD ECX, RD_ENTRYSIZE
                    JMP .loop1
.done:              RET

                    ;
                    ; Function: ELF_Load
                    ; Parses an elf file in memory
                    ;
                    ; in:
                    ;     - EBX = pointer to file in memory
                    ;     - EAX = length of file
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     unknown
                    ;

ELF_Load:           MOV EDX, [EBX]
                    CMP EDX, 0x464c457f
                    JE .check1
                    RET
.check1:            CMP byte [EBX+EI_CLASS], ELFCLASS32
                    JE .check2
                    RET
.check2:            CMP byte [EBX+EI_DATA], ELFDATA2LSB
                    JE .check3
                    RET
.check3:            CMP byte [EBX+EI_VERSION], EV_CURRENT
                    JE .check4
                    RET
.check4:            CMP word [EBX+E_TYPE], ET_EXEC
                    JE .check5
                    RET
.check5:            CMP word [EBX+E_MACHINE], EM_386
                    JE .check6
                    RET
.check6:            CMP dword [EBX+E_VERSION], EV_CURRENT
                    JE .check7
                    RET
.check7:            MOV [iFilesize], EAX
                    MOV EAX, [lpCurrentBase]
                    MOV [lpCurrentAppStart], EAX
                    MOV EDX, [EBX+E_SHOFF]
                    ADD EDX, EBX
                    MOV [lpFileOffset], EBX
                    MOV [lpSectionTable], EDX
                    XOR EAX, EAX
                    XOR ECX, ECX
                    MOV AX, [EBX+E_SHENTSIZE]
                    MOV CX, [EBX+E_SHNUM]
                    MOV [iSectionLength], EAX
                    MOV [iSectionCount], ECX
.loopsections:      PUSH ECX
                    PUSH EAX
                    PUSH EDX
                    PUSH EBX
                    Call ELF_Loadsection
                    POP EBX
                    POP EDX
                    POP EAX
                    ADD EDX, EAX
                    POP ECX
                    DEC ECX
                    JNZ .loopsections
                    
                    MOV EDX, [EBX+E_SHOFF]
                    ADD EDX, EBX
                    MOV [lpFileOffset], EBX
                    MOV [lpSectionTable], EDX
                    XOR EAX, EAX
                    XOR ECX, ECX
                    MOV AX, [EBX+E_SHENTSIZE]
                    MOV CX, [EBX+E_SHNUM]
                    MOV [iSectionLength], EAX
                    MOV [iSectionCount], ECX
.loopsections2:     PUSH ECX
                    PUSH EAX
                    PUSH EDX
                    PUSH EBX
                    Call ELF_Adjustsection
                    POP EBX
                    POP EDX
                    POP EAX
                    ADD EDX, EAX
                    POP ECX
                    DEC ECX
                    JNZ .loopsections2
                    
                    MOV EDI, [lpCurrentBase]
                    MOV EBX, [lpCurrentAppStart]
                    kernel CreateThread
                    ADD dword [lpCurrentBase], PAGE_SIZE * 2

                    RET
.fail:
                    RET


                    ;
                    ; Function: ELF_Loadsection
                    ; Parses an elf section and loads it into memory
                    ;
                    ; in:
                    ;     - EBX = image offset
                    ;     - EDX = current section header offset
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     unknown
                    ;
ELF_Loadsection:    MOV EAX, [EDX+SH_TYPE]
                    CMP EAX, SHT_PROGBITS
                    JNE .skip1
                    JMP ELF_Copysection
.skip1              CMP EAX, SHT_NOBITS
                    JNE .skip2
                    JMP ELF_Allocsection
.skip2              RET

;
                    ; Function: ELF_Adjustsection
                    ; Parses an elf relocation section and loads it into memory
                    ;
                    ; in:
                    ;     - EBX = image offset
                    ;     - EDX = current section header offset
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     unknown
                    ;
ELF_Adjustsection:  MOV EAX, [EDX+SH_TYPE]
                    CMP EAX, SHT_REL
                    JNE .skip1
                    JMP ELF_Relocatesection
.skip1              RET

                    ;
                    ; Function: ELF_Copysection
                    ; Copies a section from an ELF file to newly allocated memory
                    ;
                    ; in:
                    ;     - EBX = image offset
                    ;     - EDX = current section header offset
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     EAX, EDI
                    ;
ELF_Copysection:    PUSH EBX
                    PUSH EDX
                    MOV EBX, [EDX+SH_SIZE]
                    MOV EDI, [lpCurrentBase]
                    kernel BlockAlloc

                    ADD [lpCurrentBase], EBX

                    POP EDX
                    POP EBX

                    MOV ECX, [EDX+SH_SIZE]
                    MOV ESI, [EDX+SH_OFFSET]
                    ADD ECX, 3
                    ADD ESI, [lpFileOffset]
                    SHR ECX, 2
                    MOV [EDX+SH_OFFSET], EDI      ; we alter the ramdisk and store the actual base
                    CLD
                    REP MOVSD

                    RET

                    ;
                    ; Function: ELF_AllocSection
                    ; Parses an elf bss section header, allocates it and zeroes it
                    ;
                    ; in:
                    ;     - EBX = image offset
                    ;     - EDX = current section header offset
                    ;
                    ; out:
                    ;     unknown
                    ;
                    ; destroyed:
                    ;     EAX, EDI
                    ;
ELF_Allocsection:   PUSH EBX
                    PUSH ECX
                    PUSH EDX
                    MOV EBX, [EDX+SH_SIZE]      ; EBX = amount of bytes
                    MOV EDI, [lpCurrentBase]    ; EDI = current memory offset
                    MOV [EDX+SH_OFFSET], EDI
                    kernel BlockAlloc           ; EBX = allocated size
                    ADD [lpCurrentBase], EBX

                    MOV ECX, EBX                ; ECX = bytes
                    SHR ECX, 2                  ; ECX = dwords
                    XOR EAX, EAX                ; EAX = 0
                    REP STOSD                   ; Fill ebx bytes in this bss with zeroes

                    POP EDX
                    POP ECX
                    POP EBX
                    RET

ELF_Relocatesection:PUSH EBX
                    PUSH EDX
                    PUSH EBP
                    MOV ECX, [EDX+SH_SIZE]        ; ECX = size of relocate section
                    MOV ESI, [EDX+SH_OFFSET]      ; ESI = relative address of section
                    ADD ESI, [lpFileOffset]       ; ESI = absolute address of relocate section

                    MOV EAX, [EDX+SH_INFO]        ; EAX = index to data section header
                    MOV EBX, [EDX+SH_LINK]        ; EBX = index to symbol table header
                    IMUL DWORD [iSectionLength]   ; EDX:EAX = offset into header table
                    ADD EAX, [lpSectionTable]     ; EAX = pointer to data section header
                    MOV EDI, EAX                  ; EDI = pointer to data section header
                    MOV EBP, [EDI+SH_ADDR]        ; EBP = original virtual address of segment
                    MOV EDI, [EDI+SH_OFFSET]      ; EDI = pointer data segment to be altered

                    MOV EAX, EBX
                    IMUL DWORD [iSectionLength]
                    ADD EAX, [lpSectionTable]     ; EAX = pointer to symbol table header
                    MOV EBX, [EAX+SH_OFFSET]      ; EBX = relative pointer to symbol table
                    ADD EBX, [lpFileOffset]       ; EBX = pointer to symbol table

                    ; at this point, EAX and EDX are free
.looprel:           PUSH ECX
                    ; here EAX, ECX, and EDX are free
                    MOV EAX, [ESI+4]              ; relocation structure
                    MOV EDX, EAX                  ; copy
                    SHR EAX, 8                    ; get the section index
                    SHL EAX, 4                    ; get the section offset
                    CMP DL, 2                     ; compare relocation type
                    JE .pc32                      ; is IP-relative relocation
                    CMP DL, 1
                    JE .abs32                     ; is absolute relocation
                    HLT

.continue:          POP ECX
                    ADD ESI, 8
                    SUB ECX, 8
                    JNZ .looprel
                    POP EBP
                    POP EDX
                    POP EBX
                    RET

                    ; do R_386_PC32 relocation
.pc32:              ADD EAX, EBX                 ; EAX = pointer to symbol entry
                    XOR EDX, EDX
                    MOV DX, [EAX+ST_SHNDX]       ; EDX = section header
                    MOV ECX, EAX                 ; ECX = pointer to symbol entry
                    MOV EAX, [iSectionLength]
                    IMUL EDX                     ; EAX = relative section header offset
                    ADD EAX, [lpSectionTable]
                    MOV EDX, [EAX+SH_ADDR]
                    MOV ECX, [ESI]               ; ECX = virtual address to be modified
                    SUB ECX, EBP                 ; ECX = address to be modified relative to section
                    SUB EDX, EBP
                    ADD [EDI+ECX], EDX           ; commit to exectuable image
                    JMP .continue

                    ; do R_386_32 relocation
.abs32:             ADD EAX, EBX                 ; EAX = pointer to symbol entry
                    XOR EDX, EDX
                    MOV DX, [EAX+ST_SHNDX]       ; EDX = section header
                    MOV ECX, EAX                 ; ECX = pointer to symbol entry
                    MOV EAX, [iSectionLength]
                    IMUL EDX                     ; EAX = relative section header offset
                    ADD EAX, [lpSectionTable]    ; EAX = pointer to section header where target resides

                    ;MOV EDX, [ECX+ST_VALUE]      ; EDX = pointer to address relative to section
                    ;SUB EDX, [EAX+SH_ADDR]
                    ;MOV EAX, [EAX+SH_OFFSET]
                    
                    MOV EDX, [EAX+SH_ADDR]       ; EDX = Original virtual address of target section
                    MOV EAX, [EAX+SH_OFFSET]     ; EAX = New virtual address of target section
                    SUB EAX, EDX

                    MOV ECX, [ESI]               ; ECX = virtual address to be modified
                    SUB ECX, EBP                 ; ECX = address to be modified relative to section
                    ;ADD EAX, EDX
                    ADD [EDI+ECX], EAX           ; commit to exectuable image
                    JMP .continue


                    ; todo: get task entry point and create threads for all modules
CreateTask:         MOV EDI, [lpCurrentBase]
                    MOV EBX, lpcAppBase
                    kernel CreateThread
                    ADD dword [lpCurrentBase], PAGE_SIZE * 2
                    JMP $

; ramdisk equates
RD_NAME             EQU 0
RD_SIZE             EQU 8
RD_OFFSET           EQU 12
RD_ENTRYSIZE        EQU 16

; offsets
lpcRamdiskBase      EQU 0x80000000
lpcAppBase          EQU 0xC0000000

; vars
lpRamdisk:          DD 0
lpRamdiskEntry:     DD 0
iPhysRamdisk:       DD 0
lpCurrentBase:      DD 0
lpCurrentAppStart:  DD 0


lpFileOffset:       DD 0
lpSectionTable:     DD 0
iSectionCount:      DD 0
iSectionLength:     DD 0
iFilesize:          DD 0

stack:    TIMES 256 DD 0
stackend: