SER_DATA            EQU 0
SER_DIV_LO          EQU 0
SER_DIV_HI          EQU 1
SER_IER             EQU 1
SER_IIR             EQU 2
SER_FCR             EQU 2
SER_LCR             EQU 3
SER_MCR             EQU 4
SER_LSR             EQU 5
SER_MSR             EQU 6
SER_SCRATCH         EQU 7

Debugger_Init:      PUSH EAX
                    PUSH EDX
                    PUSH ESI

                    MOV DX, 0x2F8
                    MOV [Debugger_port], DX

                    ADD DX, SER_IER
                    MOV AL, 0x01
                    OUT DX, AL

                    ADD DX, SER_LCR-SER_IER
                    MOV AL, 0x80
                    OUT DX, AL

                    ADD DX, SER_DIV_LO-SER_LCR
                    MOV AL, 0x0C
                    OUT DX, AL

                    ADD DX, SER_DIV_HI-SER_DIV_LO
                    MOV AL, 0x00
                    OUT DX, AL

                    ADD DX, SER_LCR-SER_DIV_HI
                    MOV AL, 0x03
                    OUT DX, AL

                    ADD DX, SER_FCR-SER_LCR
                    MOV AL, 0x00
                    OUT DX, AL

                    ADD DX, SER_MCR-SER_FCR
                    MOV AL, 0x0F
                    OUT DX, AL

                    MOV EAX, 3
                    Call EnableIRQ
                    MOV EAX, 4
                    Call EnableIRQ

                    MOV EAX, 0x23
                    MOV EDX, Debugger_Int
                    Call SetIDTEntry32
                    MOV EAX, 0x24
                    MOV EDX, Debugger_Int
                    Call SetIDTEntry32
                    MOV EAX, 0x3
                    MOV EDX, Debugger_Trap
                    Call SetIDTEntry32

                    MOV ESI, .hellomessage
                    CALL Debugger_Write

                    PUSHAD
                    MOV EAX, 1
                    MOV EBX, 2
                    MOV ECX, 3
                    MOV EDX, 4
                    MOV ESI, 5
                    MOV EDI, 6
                    MOV EBP, 7
                    pushad
                    LEA EDX, [ESP]
                    Call Debugger_Regdump
                    POPAD


                    POPAD

                    POP ESI
                    POP EDX
                    POP EAX
                    RET

.hellomessage:      DB "MysticOS Kernel debugger started", 13, 10, 0



Debugger_Int:       PUSHAD

.loop:              MOV DX, [Debugger_port]

                    ADD DX, SER_LSR
                    IN AL, DX
                    TEST AL, 1
                    JZ .done
                    SUB DX, SER_LSR

                    IN AL, DX
                    OUT DX, AL
                    JMP .loop

.done:
                    MOV AL, 0x20
                    OUT 0x20, AL
                    POPAD
                    IRETD


Debugger_port:      DW 0


; Function: Debugger_Write
; Write a series of characters to the display
;
; in: 
;     ESI - pointer to null-terminated string
;
; out:
;     none
;
; destroyed:
;     ESI
;
Debugger_Write:     PUSH EAX
                    PUSH EDX
                    MOV DX, [Debugger_port]
.loop:
                    CMP byte [ESI], 0
                    JE .done
                    ADD DX, SER_LSR
.wait:              IN AL, DX
                    TEST AL, 0x20
                    JZ .wait
                    SUB DX, SER_LSR
                    LODSB
                    OUT DX, AL
                    JMP .loop
.done:
                    POP EDX
                    POP EAX
                    RET



Debugger_Poll:      RET