
Debugger_Init:      RET


; Function: Debugger_Write
; Write a series of characters to the display, using the VGA and PS2 keyboard
;
; in: 
;     ESI - pointer to null-terminated string
;
; out:
;     none
;
; destroyed:
;     ESI
;
Debugger_Write:     PUSH EAX
                    PUSH EDX
                    
.loop:
                    CMP byte [ESI], 0
                    JNE .next
                    POP EDX
                    POP EAX
                    RET
              
.next:		    LODSB

		    CMP AL, 0x8
		    JE .backspace
		    CMP AL, 0xA
		    JE .feed
		    CMP AL, 0xD
		    JE .home
		    MOV EDX, [.pos]
		    MOV AH, 0x07
		    MOV [EDX], AX
		    ADD dword [.pos], 2		    
		    JMP .loop
.backspace:	    MOV EDX, [.pos]
		    SUB EDX, 2
		    MOV AX, 0x0700
		    MOV [EDX], AX
		    MOV [.pos], EDX
		    JMP .loop
.home:		    MOV dword [.pos], 0xB8000 + 160*24
		    JMP .loop
.feed:		    PUSH ECX
		    PUSH EDI
		    PUSH ESI
		    MOV EDX, 0xB8000 + 160
		    MOV EAX, 0xB8000
.feedloop:          
                    MOV ESI, EDX
                    MOV EDI, EAX
                    MOV ECX, 160
                    REP MOVSB    ; per byte to avoid vga troubles
		    ADD EDX, 160
		    ADD EAX, 160
		    CMP EDX, 0xB8000 + 160 * 25
		    JNE .feedloop
		    
		    MOV EDI, 0xB8000 + 160 * 24
		    XOR EAX, EAX
		    MOV ECX, 160
		    REP STOSB

		    POP ESI
		    POP EDI		    
		    POP ECX
                    JMP .loop


.pos                DD 0xB8000 + 24 * 160

Debugger_Poll:      IN AL, 0x60
		    MOV AH, AL
		    IN AL, 0x61
		    OR AL, 0x80
		    OUT 0x61, AL
		    AND AL, 0x7F
		    OUT 0x61, AL

		    CMP AH, [.lastbyte]
		    JE .done
.check2		    MOV [.lastbyte], AH
		    TEST AH, 0x80
		    JNZ .done		 
.check3:	    MOVZX EAX, AH
		    MOV AL, [.keymap + EAX]
		    OR AL, AL
		    JZ .done
.submit:	    Call Debugger_inchar
.done:		    RET

.lastbyte:          DB 0
.keymap: 	    DB   0,  0, 49, 50, 51, 52, 53, 54   ; err esc  1   2   3   4   5   6
                    DB  55, 56, 57, 48,  0,  0,  8,  0   ;  7   8   9   0  - _ + = bsp tab
                    DB 113,119,101,114,116,121,117,105   ;  Q   W   E   R   T   Y   U   I
                    DB 111,112,  0,  0, 13,  0, 97,115   ;  O   P   [   ]  \n  LCt  A   S
                    DB 100,102,103,104,106,107,108,  0   ;  D   F   G   H   J   K   L   :
                    DB   0,  0,  0,  0,122,120, 99,118   ;  "   ~  LSh  |   Z   X   C   V
                    DB  98,110,109,  0,  0,  0,'/',  0   ;  B   N   M   <   >   ?  RSh
                    DB   0, 32,  0,  0,  0,  0,  0,  0   ; LAl spb Cap F01 F02 F03 F04 F05
                