; Summary: print_lfb.asm
; Utility code for printing early initialisation debug messages
; using the LFB
;
; Author:
;     Marcel Sondaar
;
; License:
;     <Public Domain>
;




                        ; Function: ClearScreen
                        ; Clears the screen
                        ;
                        ; in:
                        ;     none
                        ;
                        ; out:
                        ;     none
                        ;
                        ; destroyed:
                        ;     EAX ECX EDI
                        ;
ClearScreen:            RET




                        ; Function: PrintLine
                        ; prints a line to the display
                        ;
                        ; in:
                        ;     ESI - pointer to null-terminated string
                        ;     EDX - line number
                        ; out:
                        ;     none
                        ;
                        ; destroyed:
                        ;     EDX ESI
PrintLine:              XCHG BX, BX
                        PUSH EAX
			PUSH ECX
			PUSH EDI
                        IMUL EDX, [dwLFBPitch]          ; get offset
                        SHL EDX, 3                      ; multiply by 8
                        ADD EDX, [dwLFBOffset]          ; point to character
.loop:                  LODSB
                        OR AL, AL
                        JZ .done
                        SUB AL, 0x20
                        CMP AL, 0x60
                        JC .ok
                        MOV AL, 0x60                         
.ok:			MOVZX EDI, AL                        
                        LEA EDI, [8*EDI + font_8x8_0020]
			JMP [.modejump]

.done:                  POP EDX
                        POP ECX
                        POP EAX
                        RET

                        ; EDI -> character data
                        ; EDX -> starting pixel
                        ; preserve ESI; ECX and EAX free
.write32:		PUSH EBX
                        PUSH EDX
                        XOR ECX, ECX
                        MOV AH, 8
.loop32_y:              MOV CL, [EDI]
                        INC EDI
                        MOV AL, 8
.loop32_x:              SHR CL, 1
                        SBB EBX, EBX
                        MOV [EDX], EBX
                        ADD EDX, 4
                        DEC AL
                        JNZ .loop32_x
                        ADD EDX, [dwLFBPitch]
                        SUB EDX, 8 * 4
                        DEC AH
                        JNZ .loop32_y
                        POP EDX
			ADD EDX, 8 * 4
                        POP EBX
                        JMP .loop


.write24:               PUSH EBX
                        PUSH EDX
                        XOR ECX, ECX
                        MOV AH, 8    
.loop24_y:              MOV CL, [EDI]
                        INC EDI  
                        MOV AL, 8
.loop24_x:              SHR CL, 1
                        SBB BX, BX
                        MOV [EDX], BX
                        MOV [EDX+2], BL
                        ADD EDX, 3                         
                        DEC AL  
                        JNZ .loop24_x
                        ADD EDX, [dwLFBPitch]
                        SUB EDX, 8 * 3 
                        DEC AH  
                        JNZ .loop24_y
                        POP EDX
			ADD EDX, 8 * 3
                        POP EBX
                        JMP .loop

                        

.modejump:              DD .write32
.modejumps:		DD .write32
			DD .write32
                        DD .write24
			DD .write24
			DD .write24
			DD .write24

font_8x8_0020:      DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0020 (space)
                    DB 0x18, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x18, 0x00   ; U+0021 (!)
                    DB 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0022 (")
                    DB 0x36, 0x36, 0x7F, 0x36, 0x7F, 0x36, 0x36, 0x00   ; U+0023 (#)
                    DB 0x0C, 0x3E, 0x03, 0x1E, 0x30, 0x1F, 0x0C, 0x00   ; U+0024 ($)
                    DB 0x00, 0x63, 0x33, 0x18, 0x0C, 0x66, 0x63, 0x00   ; U+0025 (%)
                    DB 0x1C, 0x36, 0x1C, 0x6E, 0x3B, 0x33, 0x6E, 0x00   ; U+0026 (&)
                    DB 0x06, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0027 (')
                    DB 0x18, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x18, 0x00   ; U+0028 (()
                    DB 0x06, 0x0C, 0x18, 0x18, 0x18, 0x0C, 0x06, 0x00   ; U+0029 ())
                    DB 0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00   ; U+002A (*)
                    DB 0x00, 0x0C, 0x0C, 0x3F, 0x0C, 0x0C, 0x00, 0x00   ; U+002B (+)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x06   ; U+002C (,)
                    DB 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00   ; U+002D (-)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00   ; U+002E (.)
                    DB 0x60, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x01, 0x00   ; U+002F (/)
                    DB 0x3E, 0x63, 0x73, 0x7B, 0x6F, 0x67, 0x3E, 0x00   ; U+0030 (0)
                    DB 0x0C, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x3F, 0x00   ; U+0031 (1)
                    DB 0x1E, 0x33, 0x30, 0x1C, 0x06, 0x33, 0x3F, 0x00   ; U+0032 (2)
                    DB 0x1E, 0x33, 0x30, 0x1C, 0x30, 0x33, 0x1E, 0x00   ; U+0033 (3)
                    DB 0x38, 0x3C, 0x36, 0x33, 0x7F, 0x30, 0x78, 0x00   ; U+0034 (4)
                    DB 0x3F, 0x03, 0x1F, 0x30, 0x30, 0x33, 0x1E, 0x00   ; U+0035 (5)
                    DB 0x1C, 0x06, 0x03, 0x1F, 0x33, 0x33, 0x1E, 0x00   ; U+0036 (6)
                    DB 0x3F, 0x33, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x00   ; U+0037 (7)
                    DB 0x1E, 0x33, 0x33, 0x1E, 0x33, 0x33, 0x1E, 0x00   ; U+0038 (8)
                    DB 0x1E, 0x33, 0x33, 0x3E, 0x30, 0x18, 0x0E, 0x00   ; U+0039 (9)
                    DB 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x0C, 0x0C, 0x00   ; U+003A (:)
                    DB 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x0C, 0x0C, 0x06   ; U+003B (;)
                    DB 0x18, 0x0C, 0x06, 0x03, 0x06, 0x0C, 0x18, 0x00   ; U+003C (<)
                    DB 0x00, 0x00, 0x3F, 0x00, 0x00, 0x3F, 0x00, 0x00   ; U+003D (=)
                    DB 0x06, 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x06, 0x00   ; U+003E (>)
                    DB 0x1E, 0x33, 0x30, 0x18, 0x0C, 0x00, 0x0C, 0x00   ; U+003F (?)
                    DB 0x3E, 0x63, 0x7B, 0x7B, 0x7B, 0x03, 0x1E, 0x00   ; U+0040 (@)
                    DB 0x0C, 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x00   ; U+0041 (A)
                    DB 0x3F, 0x66, 0x66, 0x3E, 0x66, 0x66, 0x3F, 0x00   ; U+0042 (B)
                    DB 0x3C, 0x66, 0x03, 0x03, 0x03, 0x66, 0x3C, 0x00   ; U+0043 (C)
                    DB 0x1F, 0x36, 0x66, 0x66, 0x66, 0x36, 0x1F, 0x00   ; U+0044 (D)
                    DB 0x7F, 0x46, 0x16, 0x1E, 0x16, 0x46, 0x7F, 0x00   ; U+0045 (E)
                    DB 0x7F, 0x46, 0x16, 0x1E, 0x16, 0x06, 0x0F, 0x00   ; U+0046 (F)
                    DB 0x3C, 0x66, 0x03, 0x03, 0x73, 0x66, 0x7C, 0x00   ; U+0047 (G)
                    DB 0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x00   ; U+0048 (H)
                    DB 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+0049 (I)
                    DB 0x78, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1E, 0x00   ; U+004A (J)
                    DB 0x67, 0x66, 0x36, 0x1E, 0x36, 0x66, 0x67, 0x00   ; U+004B (K)
                    DB 0x0F, 0x06, 0x06, 0x06, 0x46, 0x66, 0x7F, 0x00   ; U+004C (L)
                    DB 0x63, 0x77, 0x7F, 0x7F, 0x6B, 0x63, 0x63, 0x00   ; U+004D (M)
                    DB 0x63, 0x67, 0x6F, 0x7B, 0x73, 0x63, 0x63, 0x00   ; U+004E (N)
                    DB 0x1C, 0x36, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00   ; U+004F (O)
                    DB 0x3F, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x0F, 0x00   ; U+0050 (P)
                    DB 0x1E, 0x33, 0x33, 0x33, 0x3B, 0x1E, 0x38, 0x00   ; U+0051 (Q)
                    DB 0x3F, 0x66, 0x66, 0x3E, 0x36, 0x66, 0x67, 0x00   ; U+0052 (R)
                    DB 0x1E, 0x33, 0x07, 0x0E, 0x38, 0x33, 0x1E, 0x00   ; U+0053 (S)
                    DB 0x3F, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+0054 (T)
                    DB 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3F, 0x00   ; U+0055 (U)
                    DB 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00   ; U+0056 (V)
                    DB 0x63, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63, 0x00   ; U+0057 (W)
                    DB 0x63, 0x63, 0x36, 0x1C, 0x1C, 0x36, 0x63, 0x00   ; U+0058 (X)
                    DB 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x1E, 0x00   ; U+0059 (Y)
                    DB 0x7F, 0x63, 0x31, 0x18, 0x4C, 0x66, 0x7F, 0x00   ; U+005A (Z)
                    DB 0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1E, 0x00   ; U+005B ([)
                    DB 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x40, 0x00   ; U+005C (\)
                    DB 0x1E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1E, 0x00   ; U+005D (])
                    DB 0x08, 0x1C, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00   ; U+005E (^)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF   ; U+005F (_)
                    DB 0x0C, 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+0060 (`)
                    DB 0x00, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x6E, 0x00   ; U+0061 (a)
                    DB 0x07, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x3B, 0x00   ; U+0062 (b)
                    DB 0x00, 0x00, 0x1E, 0x33, 0x03, 0x33, 0x1E, 0x00   ; U+0063 (c)
                    DB 0x38, 0x30, 0x30, 0x3e, 0x33, 0x33, 0x6E, 0x00   ; U+0064 (d)
                    DB 0x00, 0x00, 0x1E, 0x33, 0x3f, 0x03, 0x1E, 0x00   ; U+0065 (e)
                    DB 0x1C, 0x36, 0x06, 0x0f, 0x06, 0x06, 0x0F, 0x00   ; U+0066 (f)
                    DB 0x00, 0x00, 0x6E, 0x33, 0x33, 0x3E, 0x30, 0x1F   ; U+0067 (g)
                    DB 0x07, 0x06, 0x36, 0x6E, 0x66, 0x66, 0x67, 0x00   ; U+0068 (h)
                    DB 0x0C, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+0069 (i)
                    DB 0x30, 0x00, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1E   ; U+006A (j)
                    DB 0x07, 0x06, 0x66, 0x36, 0x1E, 0x36, 0x67, 0x00   ; U+006B (k)
                    DB 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00   ; U+006C (l)
                    DB 0x00, 0x00, 0x33, 0x7F, 0x7F, 0x6B, 0x63, 0x00   ; U+006D (m)
                    DB 0x00, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x00   ; U+006E (n)
                    DB 0x00, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x1E, 0x00   ; U+006F (o)
                    DB 0x00, 0x00, 0x3B, 0x66, 0x66, 0x3E, 0x06, 0x0F   ; U+0070 (p)
                    DB 0x00, 0x00, 0x6E, 0x33, 0x33, 0x3E, 0x30, 0x78   ; U+0071 (q)
                    DB 0x00, 0x00, 0x3B, 0x6E, 0x66, 0x06, 0x0F, 0x00   ; U+0072 (r)
                    DB 0x00, 0x00, 0x3E, 0x03, 0x1E, 0x30, 0x1F, 0x00   ; U+0073 (s)
                    DB 0x08, 0x0C, 0x3E, 0x0C, 0x0C, 0x2C, 0x18, 0x00   ; U+0074 (t)
                    DB 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x6E, 0x00   ; U+0075 (u)
                    DB 0x00, 0x00, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00   ; U+0076 (v)
                    DB 0x00, 0x00, 0x63, 0x6B, 0x7F, 0x7F, 0x36, 0x00   ; U+0077 (w)
                    DB 0x00, 0x00, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x00   ; U+0078 (x)
                    DB 0x00, 0x00, 0x33, 0x33, 0x33, 0x3E, 0x30, 0x1F   ; U+0079 (y)
                    DB 0x00, 0x00, 0x3F, 0x19, 0x0C, 0x26, 0x3F, 0x00   ; U+007A (z)
                    DB 0x38, 0x0C, 0x0C, 0x07, 0x0C, 0x0C, 0x38, 0x00   ; U+007B ({)
                    DB 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00   ; U+007C (|)
                    DB 0x07, 0x0C, 0x0C, 0x38, 0x0C, 0x0C, 0x07, 0x00   ; U+007D (})
                    DB 0x6E, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+007E (~)
                    DB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   ; U+007F
                    DB 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55   ; garbage char
