; Summary: print_vga.asm
; Utility code for printing early initialisation debug messages
; using VGA hardware
;
; Author:
;     Marcel Sondaar
;
; License:
;     <Public Domain>
;




                        ; Function: ClearScreen
                        ; Clears the screen
                        ;
                        ; in:
                        ;     none
                        ;
                        ; out:
                        ;     none
                        ;
                        ; destroyed:
                        ;     EAX ECX EDI
                        ;
ClearScreen:            MOV EDI, 0x000B8000
                        MOV [lpVideoMemoryBase], EDI
                        MOV ECX, 80*25*2 / 4
                        MOV EAX, 0x07000700
                        REP STOSD
                        RET




                        ; Function: PrintLine
                        ; prints a line to the display
                        ;
                        ; in:
                        ;     ESI - pointer to null-terminated string
                        ;     EDX - line number
                        ; out:
                        ;     none
                        ;
                        ; destroyed:
                        ;     EDX ESI
PrintLine:              PUSH EAX
                        MOV EAX, EDX                    ; copy
                        SHL EAX, 5                      ; mul with 32
                        SHL EDX, 7                      ; mul with 128
                        ADD EAX, EDX                    ; EAX = row * 160
                        ADD EAX, [lpVideoMemoryBase]    ; EAX = video+row*160
                        MOV DL, 80                      ; DL = characters to print max
.loop:                  MOV DH, [ESI]                   ; get character
                        OR DH, DH
                        JE .fill
                        MOV [EAX], DH
                        INC EAX
                        INC EAX
                        INC ESI
                        DEC DL
                        JNZ .loop
                        POP EAX
                        RET
.fill:                  MOV DH, 0
                        MOV [EAX], DH
                        INC EAX
                        INC EAX
                        DEC DL
                        JNZ .fill
                        POP EAX
                        RET

